/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.input.mouse.handlers;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.core.config.GiveMode;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.overlay.IngredientGrid;
import mezz.jei.input.UserInput;
import mezz.jei.input.mouse.IUserInputHandler;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.util.CheatUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class DeleteItemInputHandler
implements IUserInputHandler {
    private final IngredientGrid ingredientGrid;
    private final IWorldConfig worldConfig;
    private final IClientConfig clientConfig;
    private final IConnectionToServer serverConnection;

    public DeleteItemInputHandler(IngredientGrid ingredientGrid, IWorldConfig worldConfig, IClientConfig clientConfig, IConnectionToServer serverConnection) {
        this.ingredientGrid = ingredientGrid;
        this.worldConfig = worldConfig;
        this.clientConfig = clientConfig;
        this.serverConnection = serverConnection;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput userInput) {
        double mouseY;
        double mouseX = userInput.getMouseX();
        if (!this.ingredientGrid.isMouseOver(mouseX, mouseY = userInput.getMouseY())) {
            return Optional.empty();
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (!this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
            return Optional.empty();
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return Optional.empty();
        }
        ItemStack itemStack = player.f_36096_.m_142621_();
        if (itemStack.m_41619_()) {
            return Optional.empty();
        }
        if (!userInput.isSimulate()) {
            player.f_36096_.m_142503_(ItemStack.f_41583_);
            PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
            this.serverConnection.sendPacketToServer(packet);
        }
        return Optional.of(this);
    }

    public void drawTooltips(PoseStack poseStack, int mouseX, int mouseY) {
        TranslatableComponent deleteItem = new TranslatableComponent("jei.tooltip.delete.item");
        TooltipRenderer.drawHoveringText(poseStack, List.of(deleteItem), mouseX, mouseY);
    }

    public boolean shouldDeleteItemOnClick(Minecraft minecraft, double mouseX, double mouseY) {
        if (!this.worldConfig.isDeleteItemsInCheatModeActive()) {
            return false;
        }
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return false;
        }
        ItemStack itemStack = player.f_36096_.m_142621_();
        if (itemStack.m_41619_()) {
            return false;
        }
        GiveMode giveMode = this.clientConfig.getGiveMode();
        if (giveMode == GiveMode.MOUSE_PICKUP) {
            return this.ingredientGrid.getIngredientUnderMouse(mouseX, mouseY).findFirst().map(CheatUtil::getCheatItemStack).map(i -> !ItemHandlerHelper.canItemStacksStack((ItemStack)itemStack, (ItemStack)i)).orElse(true);
        }
        return true;
    }
}

