/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.Internal;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.IIngredientFilterConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.core.search.SearchMode;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.ingredients.IngredientInfo;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.render.IngredientRenderHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public final class IngredientGridTooltipHelper {
    private final RegisteredIngredients registeredIngredients;
    private final IIngredientFilterConfig ingredientFilterConfig;
    private final IWorldConfig worldConfig;
    private final IModIdHelper modIdHelper;

    public IngredientGridTooltipHelper(RegisteredIngredients registeredIngredients, IIngredientFilterConfig ingredientFilterConfig, IWorldConfig worldConfig, IModIdHelper modIdHelper) {
        this.registeredIngredients = registeredIngredients;
        this.ingredientFilterConfig = ingredientFilterConfig;
        this.worldConfig = worldConfig;
        this.modIdHelper = modIdHelper;
    }

    public <T> void drawTooltip(PoseStack poseStack, int mouseX, int mouseY, ITypedIngredient<T> value) {
        IIngredientType<T> ingredientType = value.getType();
        T ingredient = value.getIngredient();
        IngredientInfo<T> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        IIngredientRenderer<T> ingredientRenderer = ingredientInfo.getIngredientRenderer();
        List<Component> tooltip = this.getTooltip(ingredient, ingredientInfo);
        TooltipRenderer.drawHoveringText(poseStack, tooltip, mouseX, mouseY, ingredient, ingredientRenderer);
    }

    public <T> List<Component> getTooltip(T ingredient, IngredientInfo<T> ingredientInfo) {
        IIngredientRenderer<T> ingredientRenderer = ingredientInfo.getIngredientRenderer();
        IIngredientHelper<T> ingredientHelper = ingredientInfo.getIngredientHelper();
        List<Component> ingredientTooltipSafe = IngredientRenderHelper.getIngredientTooltipSafe(ingredient, ingredientRenderer, ingredientHelper, this.modIdHelper);
        ArrayList<Component> tooltip = new ArrayList<Component>(ingredientTooltipSafe);
        if (this.ingredientFilterConfig.getColorSearchMode() != SearchMode.DISABLED) {
            IngredientGridTooltipHelper.addColorSearchInfoToTooltip(tooltip, ingredient, ingredientInfo);
        }
        if (this.worldConfig.isEditModeEnabled()) {
            IngredientGridTooltipHelper.addEditModeInfoToTooltip(tooltip);
        }
        return tooltip;
    }

    private static <T> void addColorSearchInfoToTooltip(List<Component> tooltip, T ingredient, IngredientInfo<T> ingredientInfo) {
        IIngredientHelper<T> ingredientHelper;
        Iterable<Integer> colors;
        ColorNamer colorNamer = Internal.getColorNamer();
        String colorNamesString = colorNamer.getColorNames(colors = (ingredientHelper = ingredientInfo.getIngredientHelper()).getColors(ingredient)).collect(Collectors.joining(", "));
        if (!colorNamesString.isEmpty()) {
            MutableComponent colorTranslation = new TranslatableComponent("jei.tooltip.item.colors", new Object[]{colorNamesString}).m_130940_(ChatFormatting.GRAY);
            tooltip.add((Component)colorTranslation);
        }
    }

    private static void addEditModeInfoToTooltip(List<Component> tooltip) {
        List<MutableComponent> lines = List.of(TextComponent.f_131282_, new TranslatableComponent("gui.jei.editMode.description").m_130940_(ChatFormatting.DARK_GREEN), new TranslatableComponent("gui.jei.editMode.description.hide", new Object[]{KeyBindings.toggleHideIngredient.m_90863_()}).m_130940_(ChatFormatting.GRAY), new TranslatableComponent("gui.jei.editMode.description.hide.wild", new Object[]{KeyBindings.toggleWildcardHideIngredient.m_90863_()}).m_130940_(ChatFormatting.GRAY));
        tooltip.addAll(lines);
    }
}

