/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public class DrawerItemRepository
implements IItemRepository {
    protected IDrawerGroup group;

    public DrawerItemRepository(IDrawerGroup group) {
        this.group = group;
    }

    @Override
    @Nonnull
    public NonNullList<IItemRepository.ItemRecord> getAllItems() {
        NonNullList records = NonNullList.m_122779_();
        if (this.group == null) {
            return records;
        }
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (drawer.isEmpty()) continue;
            ItemStack stack = drawer.getStoredItemPrototype();
            records.add((Object)new IItemRepository.ItemRecord(stack, drawer.getStoredItemCount()));
        }
        return records;
    }

    @Override
    @Nonnull
    public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate, Predicate<ItemStack> predicate) {
        int amount = stack.m_41613_();
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!drawer.isEnabled() || !this.testPredicateInsert(drawer, stack, predicate)) continue;
            boolean empty = drawer.isEmpty();
            if (empty && !simulate) {
                drawer = drawer.setStoredItem(stack);
            }
            int n = simulate ? Math.max(amount - (empty ? drawer.getAcceptingMaxCapacity(stack) : drawer.getAcceptingRemainingCapacity()), 0) : (amount = drawer.adjustStoredItemCount(amount));
            if (amount != 0) continue;
            return ItemStack.f_41583_;
        }
        return this.stackResult(stack, amount);
    }

    @Override
    @Nonnull
    public ItemStack extractItem(@Nonnull ItemStack stack, int amount, boolean simulate, Predicate<ItemStack> predicate) {
        int remaining = amount;
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!drawer.isEnabled() || !this.testPredicateExtract(drawer, stack, predicate)) continue;
            int n = remaining = simulate ? Math.max(remaining - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-remaining);
            if (remaining != 0) continue;
            return this.stackResult(stack, amount);
        }
        return amount == remaining ? ItemStack.f_41583_ : this.stackResult(stack, amount - remaining);
    }

    @Override
    public int getStoredItemCount(@Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
        long count = 0L;
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!this.testPredicateInsert(drawer, stack, predicate) || (count += (long)drawer.getStoredItemCount()) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return (int)count;
    }

    @Override
    public int getRemainingItemCapacity(@Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
        long remainder = 0L;
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!this.testPredicateInsert(drawer, stack, predicate) || (remainder += (long)drawer.getRemainingCapacity()) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return (int)remainder;
    }

    @Override
    public int getItemCapacity(@Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
        long capacity = 0L;
        for (int slot : this.group.getAccessibleDrawerSlots()) {
            IDrawer drawer = this.group.getDrawer(slot);
            if (!this.testPredicateInsert(drawer, stack, predicate) || (capacity += (long)drawer.getMaxCapacity()) < Integer.MAX_VALUE) continue;
            return Integer.MAX_VALUE;
        }
        return (int)capacity;
    }

    protected boolean testPredicateInsert(IDrawer drawer, @Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
        return !(predicate instanceof IItemRepository.DefaultPredicate ? !drawer.canItemBeStored(stack) && !predicate.test(drawer.getStoredItemPrototype()) : !drawer.canItemBeStored(stack, predicate));
    }

    protected boolean testPredicateExtract(IDrawer drawer, @Nonnull ItemStack stack, Predicate<ItemStack> predicate) {
        return !(predicate instanceof IItemRepository.DefaultPredicate ? !drawer.canItemBeExtracted(stack) && !predicate.test(drawer.getStoredItemPrototype()) : !drawer.canItemBeStored(stack, predicate));
    }

    protected ItemStack stackResult(@Nonnull ItemStack stack, int amount) {
        ItemStack result = stack.m_41777_();
        result.m_41764_(amount);
        return result;
    }
}

