/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.math.Matrix4f;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import vazkii.botania.client.core.SkyblockWorldInfo;
import vazkii.botania.client.render.world.SkyblockSkyRenderer;
import vazkii.botania.client.render.world.WorldOverlays;
import vazkii.botania.xplat.BotaniaConfig;

@Mixin(value={LevelRenderer.class})
public class MixinLevelRenderer {
    @Shadow
    @Nullable
    private VertexBuffer f_109471_;
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Shadow
    @Nullable
    private ClientLevel f_109465_;
    @Unique
    private static final Matrix4f SUN_SCALE = Matrix4f.m_27632_((float)2.0f, (float)1.0f, (float)2.0f);
    @Unique
    private static final Matrix4f MOON_SCALE = Matrix4f.m_27632_((float)1.5f, (float)1.0f, (float)1.5f);

    @Unique
    private static boolean isGogSky() {
        SkyblockWorldInfo skyblockInfo;
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        LevelData levelData = world.m_6106_();
        boolean isGog = levelData instanceof SkyblockWorldInfo && (skyblockInfo = (SkyblockWorldInfo)levelData).isGardenOfGlass();
        return BotaniaConfig.client().enableFancySkybox() && world.m_46472_() == Level.f_46428_ && (BotaniaConfig.client().enableFancySkyboxInNormalWorlds() || isGog);
    }

    @Inject(method={"renderSky"}, slice={@Slice(from=@At(ordinal=0, value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getRainLevel(F)F"))}, at={@At(shift=At.Shift.AFTER, ordinal=0, value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lcom/mojang/math/Quaternion;)V")}, require=0)
    private void renderExtras(PoseStack ms, Matrix4f projMat, float partialTicks, Camera camera, boolean foggy, Runnable resetFog, CallbackInfo ci) {
        if (MixinLevelRenderer.isGogSky()) {
            SkyblockSkyRenderer.renderExtra(ms, Minecraft.m_91087_().f_91073_, partialTicks, 0.0f);
        }
    }

    @ModifyVariable(method={"renderSky"}, slice=@Slice(from=@At(ordinal=1, value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getTimeOfDay(F)F"), to=@At(ordinal=0, value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V")), at=@At(value="CONSTANT", args={"floatValue=30.0"}), ordinal=1, require=0)
    private Matrix4f makeSunBigger(Matrix4f matrix) {
        if (MixinLevelRenderer.isGogSky()) {
            matrix = matrix.m_27658_();
            matrix.m_27644_(SUN_SCALE);
        }
        return matrix;
    }

    @ModifyVariable(method={"renderSky"}, slice=@Slice(from=@At(ordinal=0, value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V"), to=@At(ordinal=1, value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;setShaderTexture(ILnet/minecraft/resources/ResourceLocation;)V")), at=@At(value="CONSTANT", args={"floatValue=20.0"}), ordinal=1, require=0)
    private Matrix4f makeMoonBigger(Matrix4f matrix) {
        if (MixinLevelRenderer.isGogSky()) {
            matrix.m_27644_(MOON_SCALE);
        }
        return matrix;
    }

    @Inject(method={"renderSky"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getStarBrightness(F)F")}, require=0)
    private void renderExtraStars(PoseStack ms, Matrix4f projMat, float partialTicks, Camera camera, boolean foggy, Runnable resetFog, CallbackInfo ci) {
        if (MixinLevelRenderer.isGogSky()) {
            SkyblockSkyRenderer.renderStars(this.f_109471_, ms, projMat, partialTicks, resetFog);
        }
    }

    @Inject(method={"renderLevel"}, at={@At(shift=At.Shift.AFTER, value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;applyModelViewMatrix()V", ordinal=1)})
    private void renderOverlays(PoseStack ps, float partialTicks, long unknown, boolean drawBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f projMat, CallbackInfo ci) {
        WorldOverlays.renderWorldLast(camera, partialTicks, ps, this.f_109464_, (Level)this.f_109465_);
    }
}

