/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.world;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.world.MysticalFlowerConfig;
import vazkii.botania.common.world.MysticalFlowerFeature;
import vazkii.botania.common.world.MysticalMushroomConfig;
import vazkii.botania.common.world.MysticalMushroomFeature;
import vazkii.botania.common.world.SkyblockChunkGenerator;

public class ModFeatures {
    public static final ResourceKey<PlacedFeature> MYSTICAL_FLOWERS_ID = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)ResourceLocationHelper.prefix("mystical_flowers"));
    public static final ResourceKey<PlacedFeature> MYSTICAL_MUSHROOMS_ID = ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)ResourceLocationHelper.prefix("mystical_mushrooms"));
    public static Holder<PlacedFeature> mysticalFlowersPlaced = null;
    public static Holder<PlacedFeature> mysticalMushroomsPlaced = null;
    public static final Set<Biome.BiomeCategory> TYPE_BLACKLIST = ImmutableSet.of((Object)Biome.BiomeCategory.NETHER, (Object)Biome.BiomeCategory.THEEND, (Object)Biome.BiomeCategory.ICY, (Object)Biome.BiomeCategory.MUSHROOM);

    public static void registerFeatures(BiConsumer<Feature<?>, ResourceLocation> r) {
        ResourceLocation flowersId = MYSTICAL_FLOWERS_ID.m_135782_();
        ResourceLocation mushroomsId = MYSTICAL_MUSHROOMS_ID.m_135782_();
        MysticalFlowerFeature flowers = new MysticalFlowerFeature();
        MysticalMushroomFeature mushrooms = new MysticalMushroomFeature();
        r.accept(flowers, flowersId);
        r.accept(mushrooms, mushroomsId);
        Holder configuredFlowers = FeatureUtils.m_206488_((String)flowersId.toString(), (Feature)flowers, (FeatureConfiguration)new MysticalFlowerConfig(6, 2, 2, 16, 0.05));
        Holder configuredMushrooms = FeatureUtils.m_206488_((String)mushroomsId.toString(), (Feature)mushrooms, (FeatureConfiguration)new MysticalMushroomConfig(40));
        mysticalFlowersPlaced = PlacementUtils.m_206513_((String)flowersId.toString(), (Holder)configuredFlowers, (PlacementModifier[])new PlacementModifier[0]);
        mysticalMushroomsPlaced = PlacementUtils.m_206513_((String)mushroomsId.toString(), (Holder)configuredMushrooms, (PlacementModifier[])new PlacementModifier[0]);
        SkyblockChunkGenerator.init();
    }
}

