/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelSword;
import vazkii.botania.common.proxy.IProxy;

public class ItemThunderSword
extends ItemManasteelSword {
    private static final String TAG_LIGHTNING_SEED = "lightningSeed";

    public ItemThunderSword(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), 3, -1.5f, props);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity entity, @Nonnull LivingEntity attacker) {
        if (!(entity instanceof Player) && entity != null) {
            List entities;
            double range = 8.0;
            ArrayList<LivingEntity> alreadyTargetedEntities = new ArrayList<LivingEntity>();
            int dmg = 5;
            long lightningSeed = ItemNBTHelper.getLong(stack, TAG_LIGHTNING_SEED, 0L);
            Predicate<Entity> selector = e -> e instanceof LivingEntity && e instanceof Enemy && !(e instanceof Player) && !alreadyTargetedEntities.contains(e);
            Random rand = new Random(lightningSeed);
            LivingEntity lightningSource = entity;
            int hops = entity.f_19853_.m_46470_() ? 10 : 4;
            for (int i = 0; i < hops && !(entities = entity.f_19853_.m_6249_((Entity)lightningSource, new AABB(lightningSource.m_20185_() - range, lightningSource.m_20186_() - range, lightningSource.m_20189_() - range, lightningSource.m_20185_() + range, lightningSource.m_20186_() + range, lightningSource.m_20189_() + range), selector)).isEmpty(); ++i) {
                LivingEntity target = (LivingEntity)entities.get(rand.nextInt(entities.size()));
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    target.m_6469_(DamageSource.m_19344_((Player)player), (float)dmg);
                } else {
                    target.m_6469_(DamageSource.m_19370_((LivingEntity)attacker), (float)dmg);
                }
                IProxy.INSTANCE.lightningFX(VecHelper.fromEntityCenter((Entity)lightningSource), VecHelper.fromEntityCenter((Entity)target), 1.0f, 96708, 0xAADFFF);
                alreadyTargetedEntities.add(target);
                lightningSource = target;
                --dmg;
            }
            if (!entity.f_19853_.f_46443_) {
                ItemNBTHelper.setLong(stack, TAG_LIGHTNING_SEED, entity.f_19853_.f_46441_.nextLong());
            }
        }
        return super.m_7579_(stack, entity, attacker);
    }
}

