/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;
import vazkii.botania.xplat.IXplatAbstractions;

public class ItemManaRing
extends ItemBauble {
    protected static final int MAX_MANA = 500000;
    private static final String TAG_MANA = "mana";

    public ItemManaRing(Item.Properties props) {
        super(props);
    }

    public void m_6787_(@Nonnull CreativeModeTab tab, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.m_41389_(tab)) {
            stacks.add((Object)new ItemStack((ItemLike)this));
            ItemStack full = new ItemStack((ItemLike)this);
            ItemManaRing.setMana(full, 500000);
            stacks.add((Object)full);
        }
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    protected static void setMana(ItemStack stack, int mana) {
        if (mana > 0) {
            ItemNBTHelper.setInt(stack, TAG_MANA, mana);
        } else {
            ItemNBTHelper.removeEntry(stack, TAG_MANA);
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(manaItem));
    }

    public int m_142159_(ItemStack stack) {
        IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
        return Mth.m_14169_((float)(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static class ManaItem
    implements IManaItem {
        protected final ItemStack stack;

        public ManaItem(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public int getMana() {
            return ItemNBTHelper.getInt(this.stack, ItemManaRing.TAG_MANA, 0) * this.stack.m_41613_();
        }

        @Override
        public int getMaxMana() {
            return 500000 * this.stack.m_41613_();
        }

        @Override
        public void addMana(int mana) {
            ItemManaRing.setMana(this.stack, Math.min(this.getMana() + mana, this.getMaxMana()) / this.stack.m_41613_());
        }

        @Override
        public boolean canReceiveManaFromPool(BlockEntity pool) {
            return true;
        }

        @Override
        public boolean canReceiveManaFromItem(ItemStack otherStack) {
            return true;
        }

        @Override
        public boolean canExportManaToPool(BlockEntity pool) {
            return true;
        }

        @Override
        public boolean canExportManaToItem(ItemStack otherStack) {
            return true;
        }

        @Override
        public boolean isNoExport() {
            return false;
        }
    }
}

