/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import com.google.common.base.Suppliers;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

public class ItemTerrasteelArmor
extends ItemManasteelArmor {
    private static final Supplier<ItemStack[]> armorSet = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)ModItems.terrasteelHelm), new ItemStack((ItemLike)ModItems.terrasteelChest), new ItemStack((ItemLike)ModItems.terrasteelLegs), new ItemStack((ItemLike)ModItems.terrasteelBoots)});

    public ItemTerrasteelArmor(EquipmentSlot type, Item.Properties props) {
        super(type, BotaniaAPI.instance().getTerrasteelArmorMaterial(), props);
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return "botania:textures/model/armor_terrasteel.png";
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> m_7167_(@Nonnull EquipmentSlot slot) {
        Multimap ret = super.m_7167_(slot);
        UUID uuid = new UUID(Registry.f_122827_.m_7981_((Object)this).hashCode() + slot.toString().hashCode(), 0L);
        if (slot == this.m_40402_()) {
            ret = HashMultimap.create((Multimap)ret);
            int reduction = this.m_40401_().m_7365_(slot);
            ret.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Terrasteel modifier " + this.type, (double)reduction / 20.0, AttributeModifier.Operation.ADDITION));
        }
        return ret;
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return armorSet.get();
    }

    @Override
    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.m_150930_(ModItems.terrasteelHelm);
            case EquipmentSlot.CHEST -> stack.m_150930_(ModItems.terrasteelChest);
            case EquipmentSlot.LEGS -> stack.m_150930_(ModItems.terrasteelLegs);
            case EquipmentSlot.FEET -> stack.m_150930_(ModItems.terrasteelBoots);
            default -> false;
        };
    }

    @Override
    public MutableComponent getArmorSetName() {
        return new TranslatableComponent("botania.armorset.terrasteel.name");
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        list.add((Component)new TranslatableComponent("botania.armorset.terrasteel.desc0").m_130940_(ChatFormatting.GRAY));
        list.add((Component)new TranslatableComponent("botania.armorset.terrasteel.desc1").m_130940_(ChatFormatting.GRAY));
        list.add((Component)new TranslatableComponent("botania.armorset.terrasteel.desc2").m_130940_(ChatFormatting.GRAY));
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }
}

