/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.manasteel;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IPhantomInkable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.TooltipHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.ICustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.proxy.IProxy;

public class ItemManasteelArmor
extends ArmorItem
implements ICustomDamageItem,
IPhantomInkable {
    private static final int MANA_PER_DAMAGE = 70;
    private static final String TAG_PHANTOM_INK = "phantomInk";
    public final EquipmentSlot type;
    private static final Supplier<ItemStack[]> armorSet = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)ModItems.manasteelHelm), new ItemStack((ItemLike)ModItems.manasteelChest), new ItemStack((ItemLike)ModItems.manasteelLegs), new ItemStack((ItemLike)ModItems.manasteelBoots)});

    public ItemManasteelArmor(EquipmentSlot type, Item.Properties props) {
        this(type, BotaniaAPI.instance().getManasteelArmorMaterial(), props);
    }

    public ItemManasteelArmor(EquipmentSlot type, ArmorMaterial mat, Item.Properties props) {
        super(mat, type, props);
        this.type = type;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.onArmorTick(stack, world, player);
        }
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (!world.f_46443_ && stack.m_41773_() > 0 && ManaItemHandler.instance().requestManaExact(stack, player, 140, true)) {
            stack.m_41721_(stack.m_41773_() - 1);
        }
    }

    @Override
    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return ToolCommons.damageItemIfPossible(stack, amount, entity, 70);
    }

    @Nonnull
    public final String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return this.hasPhantomInk(stack) ? "botania:textures/model/armor_invisible.png" : this.getArmorTextureAfterInk(stack, slot);
    }

    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return "botania:textures/model/armor_manasteel.png";
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        TooltipHandler.addOnShift(list, () -> this.addInformationAfterShift(stack, world, list, flags));
    }

    public void addInformationAfterShift(ItemStack stack, Level world, List<Component> list, TooltipFlag flags) {
        ItemStack[] stacks;
        Player player = IProxy.INSTANCE.getClientPlayer();
        list.add(this.getArmorSetTitle(player));
        this.addArmorSetDescription(stack, list);
        for (ItemStack armor : stacks = this.getArmorSetStacks()) {
            MutableComponent cmp = new TextComponent(" - ").m_7220_(armor.m_41786_());
            EquipmentSlot slot = ((ArmorItem)armor.m_41720_()).m_40402_();
            cmp.m_130940_(this.hasArmorSetItem(player, slot) ? ChatFormatting.GREEN : ChatFormatting.GRAY);
            list.add((Component)cmp);
        }
        if (this.hasPhantomInk(stack)) {
            list.add((Component)new TranslatableComponent("botaniamisc.hasPhantomInk").m_130940_(ChatFormatting.GRAY));
        }
    }

    public ItemStack[] getArmorSetStacks() {
        return armorSet.get();
    }

    public boolean hasArmorSet(Player player) {
        return this.hasArmorSetItem(player, EquipmentSlot.HEAD) && this.hasArmorSetItem(player, EquipmentSlot.CHEST) && this.hasArmorSetItem(player, EquipmentSlot.LEGS) && this.hasArmorSetItem(player, EquipmentSlot.FEET);
    }

    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null || player.m_150109_() == null || player.m_150109_().f_35975_ == null) {
            return false;
        }
        ItemStack stack = player.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.m_150930_(ModItems.manasteelHelm);
            case EquipmentSlot.CHEST -> stack.m_150930_(ModItems.manasteelChest);
            case EquipmentSlot.LEGS -> stack.m_150930_(ModItems.manasteelLegs);
            case EquipmentSlot.FEET -> stack.m_150930_(ModItems.manasteelBoots);
            default -> false;
        };
    }

    private int getSetPiecesEquipped(Player player) {
        int pieces = 0;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !this.hasArmorSetItem(player, slot)) continue;
            ++pieces;
        }
        return pieces;
    }

    public MutableComponent getArmorSetName() {
        return new TranslatableComponent("botania.armorset.manasteel.name");
    }

    private Component getArmorSetTitle(Player player) {
        MutableComponent end = this.getArmorSetName().m_130946_(" (" + this.getSetPiecesEquipped(player) + "/" + this.getArmorSetStacks().length + ")").m_130940_(ChatFormatting.GRAY);
        return new TranslatableComponent("botaniamisc.armorset").m_130946_(" ").m_7220_((Component)end);
    }

    public void addArmorSetDescription(ItemStack stack, List<Component> list) {
        list.add((Component)new TranslatableComponent("botania.armorset.manasteel.desc").m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public boolean hasPhantomInk(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_PHANTOM_INK, false);
    }

    @Override
    public void setPhantomInk(ItemStack stack, boolean ink) {
        ItemNBTHelper.setBoolean(stack, TAG_PHANTOM_INK, ink);
    }
}

