/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRemoveRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.block.CTBlockIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IReplacementRule;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import net.minecraft.commands.CommandFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipePureDaisy;
import vazkii.botania.common.integration.crafttweaker.CTPlugin;

@Document(value="mods/Botania/recipe/manager/PureDaisyRecipeManager")
@ZenRegister
@IRecipeHandler.For(value=IPureDaisyRecipe.class)
@ZenCodeType.Name(value="mods.botania.recipe.manager.PureDaisyRecipeManager")
public class PureDaisyRecipeManager
implements IRecipeManager<IPureDaisyRecipe>,
IRecipeHandler<IPureDaisyRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, BlockState output, CTBlockIngredient input, @ZenCodeType.OptionalInt(value=150) int time) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)new RecipePureDaisy(resourceLocation, CTPlugin.blockIngredientToStateIngredient(input), output, time, CommandFunction.CacheableFunction.f_77990_)));
    }

    @ZenCodeType.Method
    public void remove(CTBlockIngredient ingredient) {
        StateIngredient stateIngredient = CTPlugin.blockIngredientToStateIngredient(ingredient);
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipe((IRecipeManager)this, recipe -> stateIngredient.test(recipe.getOutputState())));
    }

    public void remove(IIngredient output) {
        throw new UnsupportedOperationException("The Pure Daisy does not output IItemStacks, use remove(BlockState)!");
    }

    public RecipeType<IPureDaisyRecipe> getRecipeType() {
        return ModRecipeTypes.PURE_DAISY_TYPE;
    }

    public String dumpToCommandString(IRecipeManager manager, IPureDaisyRecipe recipe) {
        StringJoiner s = new StringJoiner(", ", manager.getCommandString() + ".addRecipe(", ");");
        s.add(StringUtil.quoteAndEscape((ResourceLocation)recipe.m_6423_()));
        s.add(ExpandBlockState.getCommandString((BlockState)recipe.getOutputState()));
        s.add(CTPlugin.ingredientToCommandString(recipe.getInput()));
        if (recipe.getTime() != 150) {
            s.add(String.valueOf(recipe.getTime()));
        }
        return s.toString();
    }

    public Optional<Function<ResourceLocation, IPureDaisyRecipe>> replaceIngredients(IRecipeManager manager, IPureDaisyRecipe recipe, List<IReplacementRule> rules) {
        return Optional.empty();
    }
}

