/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.botania.common.crafting.recipe.RecipeUtils;
import vazkii.botania.common.item.ModItems;

public class SpellClothRecipe
extends CustomRecipe {
    public static final SimpleRecipeSerializer<SpellClothRecipe> SERIALIZER = new SimpleRecipeSerializer(SpellClothRecipe::new);

    public SpellClothRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundCloth = false;
        boolean foundEnchanted = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41793_() && !foundEnchanted && !stack.m_150930_(ModItems.spellCloth)) {
                foundEnchanted = true;
                continue;
            }
            if (stack.m_150930_(ModItems.spellCloth) && !foundCloth) {
                foundCloth = true;
                continue;
            }
            return false;
        }
        return foundCloth && foundEnchanted;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv) {
        ItemStack stackToDisenchant = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41793_() || stack.m_150930_(ModItems.spellCloth)) continue;
            stackToDisenchant = stack.m_41777_();
            stackToDisenchant.m_41764_(1);
            break;
        }
        if (stackToDisenchant.m_41619_()) {
            return ItemStack.f_41583_;
        }
        stackToDisenchant.m_41749_("Enchantments");
        stackToDisenchant.m_41749_("RepairCost");
        return stackToDisenchant;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    @Nonnull
    public NonNullList<ItemStack> getRemainingItems(@Nonnull CraftingContainer inv) {
        return RecipeUtils.getRemainingItemsSub((Container)inv, s -> {
            if (s.m_150930_(ModItems.spellCloth)) {
                ItemStack copy = s.m_41777_();
                copy.m_41764_(1);
                copy.m_41721_(copy.m_41773_() + 1);
                return copy;
            }
            return null;
        });
    }
}

