/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile.string;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.string.TileRedString;
import vazkii.botania.common.handler.ModSounds;

public class TileRedStringInterceptor
extends TileRedString {
    private static final Set<TileRedStringInterceptor> interceptors = new HashSet<TileRedStringInterceptor>();

    public TileRedStringInterceptor(BlockPos pos, BlockState state) {
        super(ModTiles.RED_STRING_INTERCEPTOR, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, TileRedStringInterceptor self) {
        TileRedString.commonTick(level, worldPosition, state, self);
        if (!level.f_46443_) {
            interceptors.add(self);
        }
    }

    @Override
    public boolean acceptBlock(BlockPos pos) {
        return this.f_58857_.m_7702_(pos) != null;
    }

    private boolean saneState() {
        return !this.m_58901_() && this.f_58857_.m_7702_(this.f_58858_) == this;
    }

    public static InteractionResult onInteract(Player player, Level world, BlockPos pos, InteractionHand hand) {
        if (world.f_46443_) {
            return InteractionResult.PASS;
        }
        ArrayList<TileRedStringInterceptor> remove = new ArrayList<TileRedStringInterceptor>();
        boolean did = false;
        for (TileRedStringInterceptor inter : interceptors) {
            BlockPos coords;
            if (!inter.saneState()) {
                remove.add(inter);
                continue;
            }
            if (inter.f_58857_ != world || (coords = inter.getBinding()) == null || !coords.equals((Object)pos)) continue;
            Block block = inter.m_58900_().m_60734_();
            world.m_46597_(inter.m_58899_(), (BlockState)world.m_8055_(inter.m_58899_()).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(true)));
            world.m_186460_(inter.m_58899_(), block, 2);
            did = true;
        }
        interceptors.removeAll(remove);
        if (did) {
            player.m_6674_(hand);
            world.m_5594_(null, pos, ModSounds.redStringInterceptorClick, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

