/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.internal_caps.GhostRailComponent;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.xplat.IXplatAbstractions;

public class BlockGhostRail
extends BaseRailBlock {
    public static final String TAG_FLOAT_TICKS = "botania:float_ticks";

    public BlockGhostRail(BlockBehaviour.Properties builder) {
        super(true, builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61404_, (Comparable)RailShape.NORTH_SOUTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61404_, f_152149_});
    }

    private void updateFloating(AbstractMinecart cart) {
        cart.f_19853_.m_46473_().m_6180_("cartFloating");
        GhostRailComponent persistentData = IXplatAbstractions.INSTANCE.ghostRailComponent(cart);
        int floatTicks = persistentData.floatTicks;
        Preconditions.checkState((floatTicks > 0 ? 1 : 0) != 0);
        BlockPos entPos = cart.m_142538_();
        BlockState state = cart.f_19853_.m_8055_(entPos);
        boolean air = state.m_60795_();
        if (state.m_204336_(ModTags.Blocks.GHOST_RAIL_BARRIER) || !state.m_60713_(ModBlocks.ghostRail) && state.m_204336_(BlockTags.f_13034_)) {
            cart.f_19853_.m_46796_(2003, entPos, 0);
            persistentData.floatTicks = 0;
        } else {
            BlockPos down = entPos.m_7495_();
            BlockState stateBelow = cart.f_19853_.m_8055_(down);
            boolean airBelow = stateBelow.m_60795_();
            if (air && airBelow || !air && !airBelow) {
                cart.f_19794_ = true;
            }
            cart.m_20334_(cart.m_20184_().m_7096_() * 1.4, 0.2, cart.m_20184_().m_7094_() * 1.4);
            --persistentData.floatTicks;
            cart.f_19853_.m_46796_(2000, entPos, 0);
        }
        cart.f_19853_.m_46473_().m_7238_();
    }

    public void onMinecartPass(BlockState state, Level world, BlockPos pos, AbstractMinecart cart) {
        if (!world.f_46443_) {
            IXplatAbstractions.INSTANCE.ghostRailComponent((AbstractMinecart)cart).floatTicks = 20;
            this.updateFloating(cart);
        }
    }

    public void tickCart(AbstractMinecart c) {
        if (c.f_19853_.f_46443_ || c.m_146910_()) {
            return;
        }
        GhostRailComponent persistentData = IXplatAbstractions.INSTANCE.ghostRailComponent(c);
        if (!c.m_6084_() || persistentData.floatTicks <= 0) {
            c.f_19794_ = false;
            return;
        }
        this.updateFloating(c);
        if (persistentData.floatTicks <= 0) {
            c.f_19794_ = false;
        }
    }

    @Nonnull
    public Property<RailShape> m_7978_() {
        return BlockStateProperties.f_61404_;
    }
}

