/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class CorporeaRequestTrigger
extends SimpleCriterionTrigger<Instance> {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("corporea_index_request");
    public static final CorporeaRequestTrigger INSTANCE = new CorporeaRequestTrigger();

    private CorporeaRequestTrigger() {
    }

    @Nonnull
    public ResourceLocation m_7295_() {
        return ID;
    }

    @Nonnull
    protected Instance createInstance(JsonObject json, EntityPredicate.Composite playerPredicate, DeserializationContext conditions) {
        return new Instance(playerPredicate, MinMaxBounds.Ints.m_55373_((JsonElement)json.get("extracted")), LocationPredicate.m_52629_((JsonElement)json.get("location")));
    }

    public void trigger(ServerPlayer player, ServerLevel world, BlockPos pos, int count) {
        this.m_66234_(player, instance -> instance.test(world, pos, count));
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        private final MinMaxBounds.Ints count;
        private final LocationPredicate indexPos;

        public Instance(EntityPredicate.Composite playerPredicate, MinMaxBounds.Ints count, LocationPredicate indexPos) {
            super(ID, playerPredicate);
            this.count = count;
            this.indexPos = indexPos;
        }

        @Nonnull
        public ResourceLocation m_7294_() {
            return ID;
        }

        boolean test(ServerLevel world, BlockPos pos, int count) {
            return this.count.m_55390_(count) && this.indexPos.m_52617_(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            if (this.count != MinMaxBounds.Ints.f_55364_) {
                json.add("extracted", this.count.m_55328_());
            }
            if (this.indexPos != LocationPredicate.f_52592_) {
                json.add("location", this.indexPos.m_52616_());
            }
            return json;
        }

        public MinMaxBounds.Ints getCount() {
            return this.count;
        }

        public LocationPredicate getIndexPos() {
            return this.indexPos;
        }
    }
}

