/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.world;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.ICoordBoundItem;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IXplatAbstractions;

public final class BoundTileRenderer {
    private static final MultiBufferSource.BufferSource LINE_BUFFERS = MultiBufferSource.m_109900_((Map)((Map)Util.m_137537_(() -> {
        IdentityHashMap<RenderType, BufferBuilder> ret = new IdentityHashMap<RenderType, BufferBuilder>();
        ret.put(RenderHelper.LINE_1_NO_DEPTH, new BufferBuilder(RenderHelper.LINE_1_NO_DEPTH.m_110507_()));
        ret.put(RenderHelper.LINE_4_NO_DEPTH, new BufferBuilder(RenderHelper.LINE_4_NO_DEPTH.m_110507_()));
        ret.put(RenderHelper.LINE_5_NO_DEPTH, new BufferBuilder(RenderHelper.LINE_5_NO_DEPTH.m_110507_()));
        ret.put(RenderHelper.LINE_8_NO_DEPTH, new BufferBuilder(RenderHelper.LINE_8_NO_DEPTH.m_110507_()));
        return ret;
    })), (BufferBuilder)Tesselator.m_85913_().m_85915_());

    private BoundTileRenderer() {
    }

    public static void onWorldRenderLast(Camera camera, PoseStack ms, Level level) {
        BlockPos coords;
        ICoordBoundItem coordBoundItem;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!BotaniaConfig.client().boundBlockWireframe() || player == null || player.f_19853_ != level) {
            return;
        }
        ms.m_85836_();
        int color = 0xFF000000 | Mth.m_14169_((float)((float)(ClientTickHandler.ticksInGame % 200) / 200.0f), (float)0.6f, (float)1.0f);
        if (!player.m_21205_().m_41619_() && (coordBoundItem = IXplatAbstractions.INSTANCE.findCoordBoundItem(player.m_21205_())) != null && (coords = coordBoundItem.getBinding(player.f_19853_)) != null) {
            BoundTileRenderer.renderBlockOutlineAt(camera, ms, (MultiBufferSource)LINE_BUFFERS, player.f_19853_, coords, color);
        }
        if (!player.m_21206_().m_41619_() && (coordBoundItem = IXplatAbstractions.INSTANCE.findCoordBoundItem(player.m_21206_())) != null && (coords = coordBoundItem.getBinding(player.f_19853_)) != null) {
            BoundTileRenderer.renderBlockOutlineAt(camera, ms, (MultiBufferSource)LINE_BUFFERS, player.f_19853_, coords, color);
        }
        BoundTileRenderer.renderWireframeProviders(camera, (Container)player.m_150109_(), (Player)player, ms, color);
        BoundTileRenderer.renderWireframeProviders(camera, BotaniaAPI.instance().getAccessoriesInventory((Player)player), (Player)player, ms, color);
        ms.m_85849_();
        RenderSystem.m_69465_();
        LINE_BUFFERS.m_109911_();
    }

    private static void renderWireframeProviders(Camera camera, Container inv, Player player, PoseStack ms, int color) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            Item item;
            ItemStack stackInSlot = inv.m_8020_(i);
            if (stackInSlot.m_41619_() || !((item = stackInSlot.m_41720_()) instanceof IWireframeCoordinateListProvider)) continue;
            IWireframeCoordinateListProvider provider = (IWireframeCoordinateListProvider)item;
            List<BlockPos> coordsList = provider.getWireframesToDraw(player, stackInSlot);
            for (BlockPos coords : coordsList) {
                BoundTileRenderer.renderBlockOutlineAt(camera, ms, (MultiBufferSource)LINE_BUFFERS, player.f_19853_, coords, color);
            }
            BlockPos coords = provider.getSourceWireframe(player, stackInSlot);
            if (coords == null || coords.m_123342_() == Integer.MIN_VALUE) continue;
            BoundTileRenderer.renderBlockOutlineAt(camera, ms, (MultiBufferSource)LINE_BUFFERS, player.f_19853_, coords, color, true);
        }
    }

    private static void renderBlockOutlineAt(Camera camera, PoseStack ms, MultiBufferSource buffers, Level level, BlockPos pos, int color) {
        BoundTileRenderer.renderBlockOutlineAt(camera, ms, buffers, level, pos, color, false);
    }

    private static void renderBlockOutlineAt(Camera camera, PoseStack ms, MultiBufferSource buffers, Level level, BlockPos pos, int color, boolean thick) {
        double renderPosX = camera.m_90583_().m_7096_();
        double renderPosY = camera.m_90583_().m_7098_();
        double renderPosZ = camera.m_90583_().m_7094_();
        ms.m_85836_();
        ms.m_85837_((double)pos.m_123341_() - renderPosX, (double)pos.m_123342_() - renderPosY, (double)pos.m_123343_() - renderPosZ);
        BlockState state = level.m_8055_(pos);
        List list = state.m_60808_((BlockGetter)level, pos).m_83299_();
        if (!list.isEmpty()) {
            VertexConsumer buffer = buffers.m_6299_(thick ? RenderHelper.LINE_5_NO_DEPTH : RenderHelper.LINE_1_NO_DEPTH);
            for (AABB axis : list) {
                BoundTileRenderer.renderBlockOutline(ms, buffer, axis, color);
            }
            buffer = buffers.m_6299_(thick ? RenderHelper.LINE_8_NO_DEPTH : RenderHelper.LINE_4_NO_DEPTH);
            int alpha = 64;
            color = color & 0xFFFFFF | alpha << 24;
            for (AABB axis : list) {
                BoundTileRenderer.renderBlockOutline(ms, buffer, axis, color);
            }
        }
        ms.m_85849_();
    }

    private static void renderBlockOutline(PoseStack pose, VertexConsumer buffer, AABB aabb, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)buffer, (AABB)aabb, (float)r, (float)g, (float)b, (float)a);
    }
}

