/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.botania.client.model.ModModelLayers;
import vazkii.botania.client.model.ModelBellows;
import vazkii.botania.common.block.tile.mana.TileBellows;

public class RenderTileBellows
implements BlockEntityRenderer<TileBellows> {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/bellows.png");
    private final ModelBellows model;

    public RenderTileBellows(BlockEntityRendererProvider.Context ctx) {
        this.model = new ModelBellows(ctx.m_173582_(ModModelLayers.BELLOWS));
    }

    public void render(@Nullable TileBellows bellows, float f, PoseStack ms, MultiBufferSource buffers, int light, int overlay) {
        ms.m_85836_();
        ms.m_85837_(0.5, 1.5, 0.5);
        ms.m_85841_(1.0f, -1.0f, -1.0f);
        float angle = 0.0f;
        if (bellows != null) {
            switch ((Direction)bellows.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)) {
                case SOUTH: {
                    break;
                }
                case NORTH: {
                    angle = 180.0f;
                    break;
                }
                case EAST: {
                    angle = 270.0f;
                    break;
                }
                case WEST: {
                    angle = 90.0f;
                }
            }
        }
        ms.m_85845_(Vector3f.f_122225_.m_122240_(angle));
        float fract = Math.max(0.1f, 1.0f - (bellows == null ? 0.0f : bellows.movePos + bellows.moving * f + 0.1f));
        VertexConsumer buffer = buffers.m_6299_(this.model.m_103119_(texture));
        this.model.render(ms, buffer, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f, fract);
        ms.m_85849_();
    }
}

