/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.render;

import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.decor.BlockPetalBlock;
import vazkii.botania.common.block.mana.BlockPool;
import vazkii.botania.common.block.tile.TilePlatform;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.brew.ModBrews;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.ItemManaGun;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemBloodPendant;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.lens.ItemLens;
import vazkii.botania.common.item.material.ItemPetal;
import vazkii.botania.mixin.client.AccessorMinecraft;
import vazkii.botania.xplat.IXplatAbstractions;

public final class ColorHandler {
    public static void submitBlocks(BlockHandlerConsumer blocks) {
        BlockColor vineColor = (state, world, pos, tint) -> world != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos) : FoliageColor.m_46113_();
        blocks.register(vineColor, ModBlocks.solidVines);
        blocks.register((state, world, pos, tintIndex) -> {
            BlockEntity te;
            if (tintIndex != 0) {
                return -1;
            }
            int color = ColorHelper.getColorValue(DyeColor.WHITE);
            if (world != null && pos != null && (te = world.m_7702_(pos)) instanceof TilePool) {
                TilePool pool = (TilePool)te;
                color = ColorHelper.getColorValue(pool.getColor());
            }
            if (((BlockPool)state.m_60734_()).variant == BlockPool.Variant.FABULOUS) {
                float time = ((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.005f;
                int fabulousColor = Mth.m_14169_((float)(time - (float)((int)time)), (float)0.6f, (float)1.0f);
                return MathHelper.multiplyColor(fabulousColor, color);
            }
            return color;
        }, ModBlocks.manaPool, ModBlocks.creativePool, ModBlocks.dilutedPool, ModBlocks.fabulousPool);
        blocks.register((state, world, pos, tintIndex) -> {
            float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
            return Mth.m_14169_((float)(time * 5.0f % 360.0f / 360.0f), (float)0.4f, (float)0.9f);
        }, ModBlocks.gaiaSpreader);
        blocks.register((state, world, pos, tintIndex) -> tintIndex == 0 ? ColorHelper.getColorValue(((BlockPetalBlock)state.m_60734_()).color) : -1, ModBlocks.petalBlockWhite, ModBlocks.petalBlockOrange, ModBlocks.petalBlockMagenta, ModBlocks.petalBlockLightBlue, ModBlocks.petalBlockYellow, ModBlocks.petalBlockLime, ModBlocks.petalBlockPink, ModBlocks.petalBlockGray, ModBlocks.petalBlockSilver, ModBlocks.petalBlockCyan, ModBlocks.petalBlockPurple, ModBlocks.petalBlockBlue, ModBlocks.petalBlockBrown, ModBlocks.petalBlockGreen, ModBlocks.petalBlockRed, ModBlocks.petalBlockBlack);
        blocks.register((state, world, pos, tintIndex) -> {
            TilePlatform camo;
            BlockState camoState;
            BlockEntity tile;
            if (world != null && pos != null && (tile = world.m_7702_(pos)) instanceof TilePlatform && (camoState = (camo = (TilePlatform)tile).getCamoState()) != null) {
                return camoState.m_60734_() instanceof BlockPlatform ? 0xFFFFFF : Minecraft.m_91087_().m_91298_().m_92577_(camoState, world, pos, tintIndex);
            }
            return 0xFFFFFF;
        }, ModBlocks.abstrusePlatform, ModBlocks.spectralPlatform, ModBlocks.infrangiblePlatform);
    }

    public static void submitItems(ItemHandlerConsumer items) {
        items.register((s, t) -> t == 0 ? Mth.m_14169_((float)((float)(ClientTickHandler.ticksInGame * 2 % 360) / 360.0f), (float)0.25f, (float)1.0f) : -1, new ItemLike[]{ModItems.lifeEssence, ModItems.gaiaIngot});
        items.register((s, t) -> t == 1 ? ColorHelper.getColorValue(DyeColor.m_41053_((int)ItemTwigWand.getColor1(s))) : (t == 2 ? ColorHelper.getColorValue(DyeColor.m_41053_((int)ItemTwigWand.getColor2(s))) : -1), new ItemLike[]{ModItems.twigWand, ModItems.dreamwoodWand});
        ItemColor petalHandler = (s, t) -> t == 0 ? ColorHelper.getColorValue(((ItemPetal)s.m_41720_()).color) : -1;
        for (DyeColor color : DyeColor.values()) {
            items.register(petalHandler, new ItemLike[]{ModItems.getPetal(color)});
        }
        items.register((s, t) -> t == 0 ? Minecraft.m_91087_().m_91298_().m_92577_(((BlockItem)s.m_41720_()).m_40614_().m_49966_(), null, null, t) : -1, new ItemLike[]{ModBlocks.petalBlockWhite, ModBlocks.petalBlockOrange, ModBlocks.petalBlockMagenta, ModBlocks.petalBlockLightBlue, ModBlocks.petalBlockYellow, ModBlocks.petalBlockLime, ModBlocks.petalBlockPink, ModBlocks.petalBlockGray, ModBlocks.petalBlockSilver, ModBlocks.petalBlockCyan, ModBlocks.petalBlockPurple, ModBlocks.petalBlockBlue, ModBlocks.petalBlockBrown, ModBlocks.petalBlockGreen, ModBlocks.petalBlockRed, ModBlocks.petalBlockBlack, ModBlocks.manaPool, ModBlocks.creativePool, ModBlocks.dilutedPool, ModBlocks.fabulousPool, ModBlocks.gaiaSpreader});
        items.register((s, t) -> {
            if (t == 1) {
                IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(s);
                return Mth.m_14169_((float)0.528f, (float)((float)manaItem.getMana() / 1000000.0f), (float)1.0f);
            }
            return -1;
        }, new ItemLike[]{ModItems.manaMirror});
        items.register((s, t) -> {
            if (t == 1) {
                IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(s);
                return Mth.m_14169_((float)0.528f, (float)((float)manaItem.getMana() / 500000.0f), (float)1.0f);
            }
            return -1;
        }, new ItemLike[]{ModItems.manaTablet});
        items.register((s, t) -> t == 0 ? Mth.m_14169_((float)0.55f, (float)(((float)s.m_41776_() - (float)s.m_41773_()) / (float)s.m_41776_() * 0.5f), (float)1.0f) : -1, new ItemLike[]{ModItems.spellCloth});
        items.register((s, t) -> {
            if (t != 1) {
                return -1;
            }
            Brew brew = ((IBrewItem)s.m_41720_()).getBrew(s);
            if (brew == ModBrews.fallbackBrew) {
                return s.m_41720_() instanceof ItemBloodPendant ? 12976142 : 0x989898;
            }
            int color = brew.getColor(s);
            double speed = s.m_150930_(ModItems.brewFlask) || s.m_150930_(ModItems.brewVial) ? 0.1 : 0.2;
            int add = (int)(Math.sin((double)ClientTickHandler.ticksInGame * speed) * 24.0);
            int r = Math.max(0, Math.min(255, (color >> 16 & 0xFF) + add));
            int g = Math.max(0, Math.min(255, (color >> 8 & 0xFF) + add));
            int b = Math.max(0, Math.min(255, (color & 0xFF) + add));
            return r << 16 | g << 8 | b;
        }, new ItemLike[]{ModItems.bloodPendant, ModItems.incenseStick, ModItems.brewFlask, ModItems.brewVial});
        items.register((s, t) -> {
            ItemStack lens = ItemManaGun.getLens(s);
            if (!lens.m_41619_() && t == 0) {
                return ((AccessorMinecraft)Minecraft.m_91087_()).getItemColors().m_92676_(lens, t);
            }
            if (t == 2) {
                BurstProperties props = ((ItemManaGun)s.m_41720_()).getBurstProps((Player)Minecraft.m_91087_().f_91074_, s, false, InteractionHand.MAIN_HAND);
                float mul = (float)(Math.sin((double)ClientTickHandler.ticksInGame / 5.0) * (double)0.15f);
                int c = (int)(255.0f * mul);
                int r = (props.color >> 16 & 0xFF) + c;
                int g = (props.color >> 8 & 0xFF) + c;
                int b = (props.color & 0xFF) + c;
                int cr = Mth.m_14045_((int)r, (int)0, (int)255);
                int cg = Mth.m_14045_((int)g, (int)0, (int)255);
                int cb = Mth.m_14045_((int)b, (int)0, (int)255);
                return cr << 16 | cg << 8 | cb;
            }
            return -1;
        }, new ItemLike[]{ModItems.manaGun});
        items.register((s, t) -> t == 1 ? Mth.m_14169_((float)0.75f, (float)1.0f, (float)(1.5f - (float)Math.min(1.0, Math.sin((double)Util.m_137550_() / 100.0) * 0.5 + (double)1.2f))) : -1, new ItemLike[]{ModItems.enderDagger});
        items.register((s, t) -> t == 1 && ItemTerraPick.isEnabled(s) ? Mth.m_14169_((float)0.375f, (float)((float)Math.min(1.0, Math.sin((double)Util.m_137550_() / 200.0) * 0.5 + 1.0)), (float)1.0f) : -1, new ItemLike[]{ModItems.terraPick});
        ItemColor lensHandler = (s, t) -> t == 0 ? ((ItemLens)s.m_41720_()).getLensColor(s, (Level)Minecraft.m_91087_().f_91073_) : -1;
        items.register(lensHandler, new ItemLike[]{ModItems.lensNormal, ModItems.lensSpeed, ModItems.lensPower, ModItems.lensTime, ModItems.lensEfficiency, ModItems.lensBounce, ModItems.lensGravity, ModItems.lensMine, ModItems.lensDamage, ModItems.lensPhantom, ModItems.lensMagnet, ModItems.lensExplosive, ModItems.lensInfluence, ModItems.lensWeight, ModItems.lensPaint, ModItems.lensFire, ModItems.lensPiston, ModItems.lensLight, ModItems.lensWarp, ModItems.lensRedirect, ModItems.lensFirework, ModItems.lensFlare, ModItems.lensMessenger, ModItems.lensTripwire, ModItems.lensStorm});
    }

    private ColorHandler() {
    }

    public static interface BlockHandlerConsumer {
        public void register(BlockColor var1, Block ... var2);
    }

    public static interface ItemHandlerConsumer {
        public void register(ItemColor var1, ItemLike ... var2);
    }
}

