/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec2;
import vazkii.botania.api.recipe.IPetalRecipe;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class PetalApothecaryRecipeCategory
implements IRecipeCategory<IPetalRecipe> {
    public static final ResourceLocation UID = ResourceLocationHelper.prefix("petals");
    private final IDrawableStatic background;
    private final Component localizedName;
    private final IDrawableStatic overlay;
    private final IDrawable icon;

    public PetalApothecaryRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(114, 97);
        this.localizedName = new TranslatableComponent("botania.nei.petalApothecary");
        this.overlay = guiHelper.createDrawable(ResourceLocationHelper.prefix("textures/gui/petal_overlay.png"), 17, 11, 114, 82);
        this.icon = guiHelper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModBlocks.defaultAltar));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends IPetalRecipe> getRecipeClass() {
        return IPetalRecipe.class;
    }

    @Nonnull
    public Component getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(@Nonnull IPetalRecipe recipe, @Nonnull IRecipeSlotsView slotsView, @Nonnull PoseStack ms, double mouseX, double mouseY) {
        RenderSystem.m_69478_();
        this.overlay.draw(ms, 0, 4);
        RenderSystem.m_69461_();
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull IPetalRecipe recipe, @Nonnull IFocusGroup focusGroup) {
        builder.addSlot(RecipeIngredientRole.CATALYST, 48, 45).addItemStack(new ItemStack((ItemLike)ModBlocks.defaultAltar));
        double angleBetweenEach = 360.0 / (double)recipe.m_7527_().size();
        Vec2 point = new Vec2(48.0f, 13.0f);
        Vec2 center = new Vec2(48.0f, 45.0f);
        for (Ingredient ingr : recipe.m_7527_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, (int)point.f_82470_, (int)point.f_82471_).addIngredients(ingr);
            point = PetalApothecaryRecipeCategory.rotatePointAbout(point, center, angleBetweenEach);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 10).addItemStack(recipe.m_8043_());
    }

    public static Vec2 rotatePointAbout(Vec2 in, Vec2 about, double degrees) {
        double rad = degrees * Math.PI / 180.0;
        double newX = Math.cos(rad) * (double)(in.f_82470_ - about.f_82470_) - Math.sin(rad) * (double)(in.f_82471_ - about.f_82471_) + (double)about.f_82470_;
        double newY = Math.sin(rad) * (double)(in.f_82470_ - about.f_82470_) + Math.cos(rad) * (double)(in.f_82471_ - about.f_82471_) + (double)about.f_82471_;
        return new Vec2((float)newX, (float)newY);
    }
}

