/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.gui;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block.IWandHUD;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileRuneAltar;
import vazkii.botania.common.block.tile.corporea.TileCorporeaCrystalCube;
import vazkii.botania.common.block.tile.corporea.TileCorporeaIndex;
import vazkii.botania.common.block.tile.mana.TilePool;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.ItemCraftingHalo;
import vazkii.botania.common.item.ItemSextant;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemDodgeRing;
import vazkii.botania.common.item.equipment.bauble.ItemFlightTiara;
import vazkii.botania.common.item.equipment.bauble.ItemMonocle;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.IClientXplatAbstractions;
import vazkii.botania.xplat.IXplatAbstractions;

public final class HUDHandler {
    public static final ResourceLocation manaBar = new ResourceLocation("botania:textures/gui/mana_hud.png");

    private HUDHandler() {
    }

    public static void onDrawScreenPost(PoseStack ms, float partialTicks) {
        HitResult pos;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_) {
            return;
        }
        ProfilerFiller profiler = mc.m_91307_();
        ItemStack main = mc.f_91074_.m_21205_();
        ItemStack offhand = mc.f_91074_.m_21206_();
        profiler.m_6180_("botania-hud");
        if (Minecraft.m_91087_().f_91072_.m_105205_()) {
            ItemStack dodgeRing;
            ItemStack tiara = EquipmentHandler.findOrEmpty(ModItems.flightTiara, (LivingEntity)mc.f_91074_);
            if (!tiara.m_41619_()) {
                profiler.m_6180_("flugelTiara");
                ItemFlightTiara.ClientLogic.renderHUD(ms, (Player)mc.f_91074_, tiara);
                profiler.m_7238_();
            }
            if (!(dodgeRing = EquipmentHandler.findOrEmpty(ModItems.dodgeRing, (LivingEntity)mc.f_91074_)).m_41619_()) {
                profiler.m_6180_("dodgeRing");
                ItemDodgeRing.ClientLogic.renderHUD(ms, (Player)mc.f_91074_, dodgeRing, partialTicks);
                profiler.m_7238_();
            }
        }
        if ((pos = mc.f_91077_) instanceof BlockHitResult) {
            BlockHitResult result = (BlockHitResult)pos;
            BlockPos bpos = result.m_82425_();
            BlockState state = mc.f_91073_.m_8055_(bpos);
            BlockEntity tile = mc.f_91073_.m_7702_(bpos);
            if (PlayerHelper.hasAnyHeldItem((Player)mc.f_91074_)) {
                IWandHUD hud;
                if (PlayerHelper.hasHeldItemClass((Player)mc.f_91074_, ItemTwigWand.class) && (hud = IClientXplatAbstractions.INSTANCE.findWandHud((Level)mc.f_91073_, bpos, state, tile)) != null) {
                    profiler.m_6180_("wandItem");
                    hud.renderHUD(ms, mc);
                    profiler.m_7238_();
                }
                if (tile instanceof TilePool) {
                    TilePool pool = (TilePool)tile;
                    if (!mc.f_91074_.m_21205_().m_41619_()) {
                        HUDHandler.renderPoolRecipeHUD(ms, pool, mc.f_91074_.m_21205_());
                    }
                }
            }
            if (!PlayerHelper.hasHeldItem((Player)mc.f_91074_, ModItems.lexicon)) {
                if (tile instanceof TileAltar) {
                    TileAltar altar = (TileAltar)tile;
                    TileAltar.Hud.render(altar, ms, mc);
                } else if (tile instanceof TileRuneAltar) {
                    TileRuneAltar runeAltar = (TileRuneAltar)tile;
                    TileRuneAltar.Hud.render(runeAltar, ms, mc);
                } else if (tile instanceof TileCorporeaCrystalCube) {
                    TileCorporeaCrystalCube cube = (TileCorporeaCrystalCube)tile;
                    HUDHandler.renderCrystalCubeHUD(ms, cube);
                }
            }
        }
        TileCorporeaIndex.getInputHandler();
        if (!TileCorporeaIndex.getNearbyValidIndexes((Player)mc.f_91074_).isEmpty() && mc.f_91080_ instanceof ChatScreen) {
            profiler.m_6180_("nearIndex");
            HUDHandler.renderNearIndexDisplay(ms);
            profiler.m_7238_();
        }
        if (!main.m_41619_() && main.m_41720_() instanceof ItemCraftingHalo) {
            profiler.m_6180_("craftingHalo_main");
            ItemCraftingHalo.Rendering.renderHUD(ms, (Player)mc.f_91074_, main);
            profiler.m_7238_();
        } else if (!offhand.m_41619_() && offhand.m_41720_() instanceof ItemCraftingHalo) {
            profiler.m_6180_("craftingHalo_off");
            ItemCraftingHalo.Rendering.renderHUD(ms, (Player)mc.f_91074_, offhand);
            profiler.m_7238_();
        }
        if (!main.m_41619_() && main.m_41720_() instanceof ItemSextant) {
            profiler.m_6180_("sextant");
            ItemSextant.Hud.render(ms, (Player)mc.f_91074_, main);
            profiler.m_7238_();
        }
        if (ItemMonocle.hasMonocle((LivingEntity)mc.f_91074_)) {
            profiler.m_6180_("monocle");
            ItemMonocle.Hud.render(ms, (Player)mc.f_91074_);
            profiler.m_7238_();
        }
        profiler.m_6180_("manaBar");
        LocalPlayer player = mc.f_91074_;
        if (!player.m_5833_()) {
            int totalMana = 0;
            int totalMaxMana = 0;
            boolean anyRequest = false;
            Inventory mainInv = player.m_150109_();
            Container accInv = BotaniaAPI.instance().getAccessoriesInventory((Player)player);
            int invSize = mainInv.m_6643_();
            int size = invSize + accInv.m_6643_();
            for (int i = 0; i < size; ++i) {
                boolean useAccessories = i >= invSize;
                Object inv = useAccessories ? accInv : mainInv;
                ItemStack stack = inv.m_8020_(i - (useAccessories ? invSize : 0));
                if (stack.m_41619_()) continue;
                anyRequest = anyRequest || stack.m_204117_(ModTags.Items.MANA_USING_ITEMS);
            }
            List<ItemStack> items = ManaItemHandler.instance().getManaItems((Player)player);
            List<ItemStack> acc = ManaItemHandler.instance().getManaAccesories((Player)player);
            for (ItemStack stack : Iterables.concat(items, acc)) {
                IManaItem manaItem = IXplatAbstractions.INSTANCE.findManaItem(stack);
                if (manaItem.isNoExport()) continue;
                totalMana += manaItem.getMana();
                totalMaxMana += manaItem.getMaxMana();
            }
            if (anyRequest) {
                HUDHandler.renderManaInvBar(ms, totalMana, totalMaxMana);
            }
        }
        profiler.m_6182_("itemsRemaining");
        ItemsRemainingRenderHandler.render(ms, partialTicks);
        profiler.m_7238_();
        profiler.m_7238_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderManaInvBar(PoseStack ms, int totalMana, int totalMaxMana) {
        Minecraft mc = Minecraft.m_91087_();
        int width = 182;
        int x = mc.m_91268_().m_85445_() / 2 - width / 2;
        int y = mc.m_91268_().m_85446_() - BotaniaConfig.client().manaBarHeight();
        width = totalMaxMana == 0 ? 0 : (int)((double)width * ((double)totalMana / (double)totalMaxMana));
        if (width == 0) {
            if (totalMana > 0) {
                width = 1;
            } else {
                return;
            }
        }
        int color = Mth.m_14169_((float)0.55f, (float)((float)Math.min(1.0, Math.sin((double)Util.m_137550_() / 200.0) * 0.5 + 1.0)), (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.m_157429_((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)(1.0f - (float)r / 255.0f));
        RenderSystem.m_157456_((int)0, (ResourceLocation)manaBar);
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        RenderHelper.drawTexturedModalRect(ms, x, y, 0, 251, width, 5);
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void renderPoolRecipeHUD(PoseStack ms, TilePool tile, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        ProfilerFiller profiler = mc.m_91307_();
        profiler.m_6180_("poolRecipe");
        IManaInfusionRecipe recipe = tile.getMatchingRecipe(stack, tile.m_58904_().m_8055_(tile.m_58899_().m_7495_()));
        if (recipe != null) {
            int x = mc.m_91268_().m_85445_() / 2 - 11;
            int y = mc.m_91268_().m_85446_() / 2 + 10;
            int u = tile.getCurrentMana() >= recipe.getManaToConsume() ? 0 : 22;
            int v = mc.f_91074_.m_7755_().getString().equals("haighyorkie") && mc.f_91074_.m_6144_() ? 23 : 8;
            RenderSystem.m_69478_();
            RenderSystem.m_69405_((int)770, (int)771);
            RenderSystem.m_157456_((int)0, (ResourceLocation)manaBar);
            RenderHelper.drawTexturedModalRect(ms, x, y, u, v, 22, 15);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.m_91291_().m_115203_(stack, x - 20, y);
            mc.m_91291_().m_115203_(recipe.m_8043_(), x + 26, y);
            mc.m_91291_().m_115169_(mc.f_91062_, recipe.m_8043_(), x + 26, y);
            RenderSystem.m_69461_();
        }
        profiler.m_7238_();
    }

    private static void renderCrystalCubeHUD(PoseStack ms, TileCorporeaCrystalCube tile) {
        Minecraft mc = Minecraft.m_91087_();
        ProfilerFiller profiler = mc.m_91307_();
        profiler.m_6180_("crystalCube");
        ItemStack target = tile.getRequestTarget();
        if (!target.m_41619_()) {
            String s1 = target.m_41786_().getString();
            String s2 = tile.getItemCount() + "x";
            int strlen = Math.max(mc.f_91062_.m_92895_(s1), mc.f_91062_.m_92895_(s2));
            int w = mc.m_91268_().m_85445_();
            int h = mc.m_91268_().m_85446_();
            int boxH = h / 2 + (tile.locked ? 20 : 10);
            GuiComponent.m_93172_((PoseStack)ms, (int)(w / 2 + 8), (int)(h / 2 - 12), (int)(w / 2 + strlen + 32), (int)boxH, (int)0x44000000);
            GuiComponent.m_93172_((PoseStack)ms, (int)(w / 2 + 6), (int)(h / 2 - 14), (int)(w / 2 + strlen + 34), (int)(boxH + 2), (int)0x44000000);
            mc.f_91062_.m_92750_(ms, s1, (float)(w / 2 + 30), (float)(h / 2 - 10), 0x6666FF);
            mc.f_91062_.m_92750_(ms, tile.getItemCount() + "x", (float)(w / 2 + 30), (float)(h / 2), 0xFFFFFF);
            if (tile.locked) {
                mc.f_91062_.m_92750_(ms, I18n.m_118938_((String)"botaniamisc.locked", (Object[])new Object[0]), (float)(w / 2 + 30), (float)(h / 2 + 10), 0xFFAA00);
            }
            mc.m_91291_().m_115203_(target, w / 2 + 10, h / 2 - 10);
        }
        profiler.m_7238_();
    }

    private static void renderNearIndexDisplay(PoseStack ms) {
        Minecraft mc = Minecraft.m_91087_();
        String txt0 = I18n.m_118938_((String)"botaniamisc.nearIndex0", (Object[])new Object[0]);
        String txt1 = ChatFormatting.GRAY + I18n.m_118938_((String)"botaniamisc.nearIndex1", (Object[])new Object[0]);
        String txt2 = ChatFormatting.GRAY + I18n.m_118938_((String)"botaniamisc.nearIndex2", (Object[])new Object[0]);
        int l = Math.max(mc.f_91062_.m_92895_(txt0), Math.max(mc.f_91062_.m_92895_(txt1), mc.f_91062_.m_92895_(txt2))) + 20;
        int x = mc.m_91268_().m_85445_() - l - 20;
        int y = mc.m_91268_().m_85446_() - 60;
        GuiComponent.m_93172_((PoseStack)ms, (int)(x - 6), (int)(y - 6), (int)(x + l + 6), (int)(y + 37), (int)0x44000000);
        GuiComponent.m_93172_((PoseStack)ms, (int)(x - 4), (int)(y - 4), (int)(x + l + 4), (int)(y + 35), (int)0x44000000);
        mc.m_91291_().m_115203_(new ItemStack((ItemLike)ModBlocks.corporeaIndex), x, y + 10);
        mc.f_91062_.m_92750_(ms, txt0, (float)(x + 20), (float)y, 0xFFFFFF);
        mc.f_91062_.m_92750_(ms, txt1, (float)(x + 20), (float)(y + 14), 0xFFFFFF);
        mc.f_91062_.m_92750_(ms, txt2, (float)(x + 20), (float)(y + 24), 0xFFFFFF);
    }

    public static void drawSimpleManaHUD(PoseStack ms, int color, int mana, int maxMana, String name) {
        RenderSystem.m_69478_();
        RenderSystem.m_69405_((int)770, (int)771);
        Minecraft mc = Minecraft.m_91087_();
        int x = mc.m_91268_().m_85445_() / 2 - mc.f_91062_.m_92895_(name) / 2;
        int y = mc.m_91268_().m_85446_() / 2 + 10;
        mc.f_91062_.m_92750_(ms, name, (float)x, (float)y, color);
        x = mc.m_91268_().m_85445_() / 2 - 51;
        HUDHandler.renderManaBar(ms, x, y += 10, color, 1.0f, mana, maxMana);
        RenderSystem.m_69461_();
    }

    public static void drawComplexManaHUD(int color, PoseStack ms, int mana, int maxMana, String name, ItemStack bindDisplay, boolean properlyBound) {
        HUDHandler.drawSimpleManaHUD(ms, color, mana, maxMana, name);
        Minecraft mc = Minecraft.m_91087_();
        int x = mc.m_91268_().m_85445_() / 2 + 55;
        int y = mc.m_91268_().m_85446_() / 2 + 12;
        mc.m_91291_().m_115203_(bindDisplay, x, y);
        RenderSystem.m_69465_();
        ms.m_85836_();
        ms.m_85837_(0.0, 0.0, (double)(mc.m_91291_().f_115093_ + 50.0f + 200.0f + 1.0f));
        if (properlyBound) {
            mc.f_91062_.m_92750_(ms, "\u2714", (float)(x + 10), (float)(y + 9), 19456);
            mc.f_91062_.m_92750_(ms, "\u2714", (float)(x + 10), (float)(y + 8), 774669);
        } else {
            mc.f_91062_.m_92750_(ms, "\u2718", (float)(x + 10), (float)(y + 9), 0x4C0000);
            mc.f_91062_.m_92750_(ms, "\u2718", (float)(x + 10), (float)(y + 8), 13764621);
        }
        ms.m_85849_();
        RenderSystem.m_69482_();
    }

    public static void renderManaBar(PoseStack ms, int x, int y, int color, float alpha, int mana, int maxMana) {
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)manaBar);
        RenderHelper.drawTexturedModalRect(ms, x, y, 0, 0, 102, 5);
        int manaPercentage = Math.max(0, (int)((double)mana / (double)maxMana * 100.0));
        if (manaPercentage == 0 && mana > 0) {
            manaPercentage = 1;
        }
        RenderHelper.drawTexturedModalRect(ms, x + 1, y + 1, 0, 5, 100, 3);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
        RenderHelper.drawTexturedModalRect(ms, x + 1, y + 1, 0, 5, Math.min(100, manaPercentage), 3);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

