local sounds = require("__base__.prototypes.entity.demo-sounds")

data:extend(
{
  {
    type = "furnace",
    name = "electric-furnace-2",
    icon = "__base__/graphics/icons/electric-furnace.png",
    icon_size = 64, icon_mipmaps = 4,
    flags = {"placeable-neutral", "placeable-player", "player-creation"},
    minable = {mining_time = 1, result = "electric-furnace-2"},
    max_health = 150,
    corpse = "big-remnants",
    dying_explosion = "medium-explosion",
    resistances =
    {
      {
        type = "fire",
        percent = 80
      }
    },
    collision_box = {{-1.2, -1.2}, {1.2, 1.2}},
    selection_box = {{-1.5, -1.5}, {1.5, 1.5}},
    crafting_categories = {"smelting", "fluid-furnace"},
    result_inventory_size = 0,
    crafting_speed = 2,
    energy_usage = "180kW",
    source_inventory_size = 0,
    energy_source =
    {
      type = "electric",
      usage_priority = "secondary-input",
      emissions_per_minute = 0.005
    },
    working_sound =
    {
      sound =
      {
        filename = "__base__/sound/electric-furnace.ogg",
        volume = 0.6
      },
      --max_sounds_per_type = 2,
    },
    animation =
    {
      filename = "__base__/graphics/entity/electric-furnace/electric-furnace-base.png",
      priority = "high",
      width = 129,
      height = 100,
      frame_count = 1,
      animation_speed = 0.5,
      shift = {0.421875, 0}
    },
    fluid_boxes =
    {
      {
        production_type = "input",
        pipe_picture = assembler2pipepictures(),
        pipe_covers = pipecoverspictures(),
        base_area = 10,
        base_level = -1,
        pipe_connections = {{ type="input", position = {0, -2} }}
      },
      {
        production_type = "output",
        pipe_picture = assembler2pipepictures(),
        pipe_covers = pipecoverspictures(),
        base_area = 10,
        base_level = 1,
        pipe_connections = {{ type="output", position = {0, 2} }}
      }
    },
    fast_replaceable_group = "furnace"
  },
  {
    type = "corpse",
    name = "small-biter-fast-corpse",
    icon = "__base__/graphics/icons/small-biter-corpse.png",
    icon_size = 64, icon_mipmaps = 4,
    selection_box = {{-0.8, -0.8}, {0.8, 0.8}},
    selectable_in_game = false,
    subgroup="corpses",
    order = "c[corpse]-a[biter]-a[small]",
    flags = {"placeable-neutral", "placeable-off-grid", "building-direction-8-way", "not-repairable", "not-on-map"},
    dying_speed = 0.04,
    time_before_removed = 60,
    final_render_layer = "corpse",
    animation = biterdieanimation(small_biter_scale, small_biter_tint1, small_biter_tint2)
  },
  {
    type = "electric-energy-interface",
    name = "electric-energy-interface-test",
    icon = "__base__/graphics/icons/small-biter-corpse.png",
    icon_size = 64, icon_mipmaps = 4,
    flags = {"placeable-neutral", "player-creation"},
    max_health = 500,
    corpse = "small-remnants",
    collision_box = {{-0.35, -0.35}, {0.35, 0.35}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    energy_source =
    {
      buffer_capacity = "50MJ",
      usage_priority = "primary-input",
      input_flow_limit = "1500kW",
      output_flow_limit = "0kW"
    },
    order="b[bomb]",
    subgroup = "equipment"
  },
  {
    type = "pipe", -- pipe that has 4 normal connections and 4 underground; from underground-pipe-pack mod
    name = "4-to-4-pipe",
    --icon = "__underground-pipe-pack__/graphics/icons/four-to-four-t1.png",
    icon = "__base__/graphics/icons/pipe.png",
    icon_size = 64, icon_mipmaps = 4,
    flags = {"placeable-neutral", "player-creation"},
    minable = {mining_time = 0.5, result = "4-to-4-pipe"},
    max_health = 100,
    corpse = "small-remnants",
    resistances =
    {
      {
        type = "fire",
        percent = 80
      },
      {
        type = "impact",
        percent = 30
      }
    },
    fast_replaceable_group = "pipe",
    collision_box = {{-0.29, -0.29}, {0.29, 0.29}},
    selection_box = {{-0.5, -0.5}, {0.5, 0.5}},
    fluid_box =
    {
      base_area = 1,
      pipe_connections =
      {
        { position = {0, -1} },
        { position = {1, 0} },
        { position = {0, 1} },
        { position = {-1, 0} },
        {
          position = {0, -1},
          max_underground_distance = 11
        },
        {
          position = {0, 1},
          max_underground_distance = 11
        },
        {
          position = {1, 0},
          max_underground_distance = 11
        },
        {
          position = {-1, 0},
          max_underground_distance = 11
        }
      }
    },
    pictures = pipepictures(),
    working_sound =
    {
      sound = sounds.pipe,
      match_volume_to_activity = true,
      audible_distance_modifier = 0.3,
      fade_in_ticks = 4,
      fade_out_ticks = 60
    },
    horizontal_window_bounding_box = {{-0.25, -0.28125}, {0.25, 0.15625}},
    vertical_window_bounding_box = {{-0.28125, -0.5}, {0.03125, 0.125}}
  },
})

local roboport2 = util.table.deepcopy(data.raw.roboport.roboport)
roboport2.name = "roboport2"
roboport2.logistics_radius = 50
roboport2.minable.result = "roboport2"
roboport2.fast_replaceable_group = "roboport"
data.raw.roboport.roboport2 = roboport2

data.raw.roboport.roboport.fast_replaceable_group = "roboport"

-- made for test Roboport / TeleportOfflineRoboportIntoPower
local fastRechargeRoboport = util.table.deepcopy(data.raw.roboport.roboport)
fastRechargeRoboport.name = "fast-recharge-roboport"
fastRechargeRoboport.order = "a-a"
fastRechargeRoboport.recharge_minimum = "200kJ" -- /200
data.raw.roboport[fastRechargeRoboport.name] = fastRechargeRoboport

local beacon2 = util.table.deepcopy(data.raw.beacon["beacon"])
beacon2.name = "beacon2"
beacon2.minable.result = "beacon2"
beacon2.fast_replaceable_group = "beacon"
beacon2.allowed_effects = {"consumption", "speed", "productivity", "pollution"}
beacon2.distribution_effectivity = 1
data.raw.beacon.beacon2 = beacon2

local cannon_projectile2 = util.table.deepcopy(data.raw.projectile["cannon-projectile"])
cannon_projectile2.name = "test-decelerating-cannon-projectile"
cannon_projectile2.acceleration = -0.1
data.raw.projectile["test-decelerating-cannon-projectile"] = cannon_projectile2

data.raw.beacon["beacon"].fast_replaceable_group = "beacon"

local fastCorpse = util.table.deepcopy(data.raw.corpse["big-biter-corpse"])
fastCorpse.name = "fast-corpse"
fastCorpse.time_before_removed = 10
fastCorpse.dying_speed = 1
data.raw.corpse["fast-corpse"] = fastCorpse

data.raw["boiler"]["boiler"].additional_pastable_entities = {"pipe"}

local cargoWagon2 = util.table.deepcopy(data.raw["cargo-wagon"]["cargo-wagon"])
cargoWagon2.name = "cargo-wagon-with-grid"
cargoWagon2.equipment_grid = "large-equipment-grid"
cargoWagon2.minable = {mining_time = 1, result = cargoWagon2.name}
data.raw["cargo-wagon"][cargoWagon2.name] = cargoWagon2

local car2 = util.table.deepcopy(data.raw.car["car"])
car2.name = "car-with-grid"
car2.equipment_grid = "large-equipment-grid"
car2.minable = {mining_time = 0.4, result = car2.name}
data.raw.car[car2.name] = car2

local smallBiter2 = util.table.deepcopy(data.raw.unit["small-biter"])
smallBiter2.name = "small-biter-2"
smallBiter2.flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air"}
data.raw.unit[smallBiter2.name] = smallBiter2

-- made for test TestManualBuilding/CollisionConsistency
local floatingChest = util.table.deepcopy(data.raw.container["wooden-chest"])
floatingChest.name = "floating-chest"
floatingChest.localised_name = "entity-name.wooden-chest"
floatingChest.collision_mask = { "ground-tile", "object-layer" }
data.raw.container[floatingChest.name] = floatingChest

-- made for test PathFinding / SendMoreAroundLongerPathWithObstacles
local fastSmallBiter = util.table.deepcopy(data.raw.unit["small-biter"])
fastSmallBiter.name = "fast-small-biter"
fastSmallBiter.movement_speed = 2 -- 10x
-- fastSmallBiter.flags = {"placeable-player", "placeable-enemy", "placeable-off-grid", "breaths-air"}
data.raw.unit[fastSmallBiter.name] = fastSmallBiter

-- made for test CraftingMachine / EnergyIsConsumedProperly
local fastSteelFurnace = util.table.deepcopy(data.raw.furnace["steel-furnace"])
fastSteelFurnace.name = "fast-steel-furnace"
fastSteelFurnace.order = "a-a"
fastSteelFurnace.crafting_speed = fastSteelFurnace.crafting_speed * 2
fastSteelFurnace.energy_usage = "9MW" -- 50x
data.raw.furnace[fastSteelFurnace.name] = fastSteelFurnace

-- made for fluid tests
local fastChemicalPlant = util.table.deepcopy(data.raw["assembling-machine"]["chemical-plant"])
fastChemicalPlant.name = "fast-chemical-plant"
fastChemicalPlant.order = "a-a"
fastChemicalPlant.crafting_speed = fastChemicalPlant.crafting_speed * 10
fastSteelFurnace.energy_usage = "9MW" -- 50x
data.raw["assembling-machine"][fastChemicalPlant.name] = fastChemicalPlant

-- made for test Reactor / SingleReactorSetup, with 1000x decreased heat capacity.
local fastReactor = util.table.deepcopy(data.raw.reactor["nuclear-reactor"])
fastReactor.name = "fast-nuclear-reactor"
fastReactor.order = "a-b"
fastReactor.heat_buffer.specific_heat = "100kJ" -- /100
data.raw.reactor[fastReactor.name] = fastReactor

local fastHeatPipe = util.table.deepcopy(data.raw["heat-pipe"]["heat-pipe"])
fastHeatPipe.name = "fast-heat-pipe"
fastHeatPipe.order = "a-a"
fastHeatPipe.heat_buffer.specific_heat = "10kJ" -- /100
data.raw["heat-pipe"][fastHeatPipe.name] = fastHeatPipe

local fastHeatExchanger = util.table.deepcopy(data.raw.boiler["heat-exchanger"])
fastHeatExchanger.name = "fast-heat-exchanger"
fastHeatExchanger.order = "a-a"
fastHeatExchanger.energy_source.specific_heat = "10kJ" -- /100
data.raw.boiler[fastHeatExchanger.name] = fastHeatExchanger

-- made for test CircuitNetwork / MiningDrillStopAndRead
local fastElectricDrill = util.table.deepcopy(data.raw["mining-drill"]["electric-mining-drill"])
fastElectricDrill.name = "fast-electric-mining-drill"
fastElectricDrill.order = "a-a"
fastElectricDrill.mining_speed = 2.5 -- 5x
data.raw["mining-drill"][fastElectricDrill.name] = fastElectricDrill

-- made for test LogisticCellConnectDistance
local roboport2 = util.table.deepcopy(data.raw["roboport"]["roboport"])
roboport2.name = "roboport-2"
roboport2.order = "a-a"
roboport2.logistics_radius = 5
roboport2.logistics_connection_distance = 50

data.raw["roboport"][roboport2.name] = roboport2

local turbo_locomotive = util.table.deepcopy(data.raw["locomotive"]["locomotive"])
turbo_locomotive.name = "turbo-locomotive"
turbo_locomotive.order = "turbo-locomotive"
turbo_locomotive.weight = 2000
turbo_locomotive.max_speed = 12 -- 10x
turbo_locomotive.max_power = "50000kW"
turbo_locomotive.reversing_power_modifier = 0.6
turbo_locomotive.braking_force = 10000
turbo_locomotive.friction_force = 0.0015
turbo_locomotive.vertical_selection_shift = -0.5
turbo_locomotive.air_resistance = 0.002
turbo_locomotive.connection_distance = 3.3
turbo_locomotive.joint_distance = 4.6
turbo_locomotive.energy_per_hit_point = 5
turbo_locomotive.burner =
{
  effectivity = 1000,
  fuel_inventory_size = 3,
  fuel_category = "chemical"
}

data.raw["locomotive"][turbo_locomotive.name] = turbo_locomotive

local strong_gate = util.table.deepcopy(data.raw["gate"]["gate"])
strong_gate.name = "strong-gate"
strong_gate.order = "strong-gate"
strong_gate.max_health = 500
data.raw["gate"][strong_gate.name] = strong_gate

local heat_assembler = util.table.deepcopy(data.raw["assembling-machine"]["assembling-machine-1"])
heat_assembler.name = "heat-assembler"
heat_assembler.order = "heat-assembler"
heat_assembler.energy_source =
{
  connections =
  {
    {
      direction = 2,
      position =
      {
        1.0,
        0
      }
    }
  },
  max_temperature = 1000,
  max_transfer = "2GW",
  specific_heat = "1MJ",
  type = "heat"
}
data.raw["assembling-machine"][heat_assembler.name] = heat_assembler

-- assembler with fluid energy source
local fluid_assembler = table.deepcopy(data.raw["assembling-machine"]["assembling-machine-1"])
fluid_assembler.type = "assembling-machine"
fluid_assembler.name = "fluid-assembler"
fluid_assembler.order = "a-b-c"
fluid_assembler.energy_source =
{
  type = "fluid",
  fluid_box =
  {
    production_type = "input",
    pipe_picture = assembler2pipepictures(),
    pipe_covers = pipecoverspictures(),
    base_area = 1,
    pipe_connections = {{ type="input", position = {0, -2}},
                              --{ type="input-output", position = {2, 0}},
                              --{ type="input-output", position = {0, 2}},
                              --{ type="input-output", position = {-2, 0}}
                            },
    secondary_draw_orders = {north = -1},
    filter = "steam"
  },
  maximum_temperature = 1000.0,
  burns_fluid = false,
  scale_fluid_usage = true,
  emissions_per_minute = 1,
  effectivity = 2
}
fluid_assembler.fluid_boxes =
{
  {
    production_type = "input",
    pipe_picture = assembler2pipepictures(),
    pipe_covers = pipecoverspictures(),
    base_area = 1,
    base_level = -1,
    pipe_connections = {{ type="input", position = {2, 0} }},
    secondary_draw_orders = { north = -1 }
  },
  {
    production_type = "output",
    pipe_picture = assembler2pipepictures(),
    pipe_covers = pipecoverspictures(),
    base_area = 1,
    base_level = 1,
    pipe_connections = {{ type="output", position = {-2, 0} }},
    secondary_draw_orders = { north = -1 }
  }
}
data.raw["assembling-machine"][fluid_assembler.name] = fluid_assembler

-- Fixed recipe assembler
local fixedFluidRecipeChemicalPlant = util.table.deepcopy(data.raw["assembling-machine"]["chemical-plant"])
fixedFluidRecipeChemicalPlant.name = "fixed-fluid-recipe-chemical-plant"
fixedFluidRecipeChemicalPlant.order = "a-a"
fixedFluidRecipeChemicalPlant.fixed_recipe = "sulfur"
data.raw["assembling-machine"][fixedFluidRecipeChemicalPlant.name] = fixedFluidRecipeChemicalPlant

local bullet_turret = util.table.deepcopy(data.raw["ammo-turret"]["gun-turret"])
bullet_turret.name = "bullet-turret"
bullet_turret.attack_parameters =
{
  type = "projectile",
  ammo_category = "bullet",
  cooldown = 30,
  projectile_creation_distance = 1.39375,
  projectile_center = {0, -0.0875}, -- same as gun_turret_attack shift
  range = 50,
  lead_target_for_projectile_speed = 1
}
bullet_turret.order = "noob"
data:extend{bullet_turret}

local bullet_projectile = util.table.deepcopy(data.raw.projectile["shotgun-pellet"])
bullet_projectile.name = "bullet-projectile"
bullet_projectile.action =
{
  type = "direct",
  action_delivery =
  {
    type = "instant",
    target_effects =
    {
      {
        type = "create-sticker",
        sticker = "slowdown-sticker"
      },
      {
        type = "damage",
        damage = {amount = 5, type = "physical"}
      },
    }
  }
}
data:extend{bullet_projectile}

local tank_with_grid = util.table.deepcopy(data.raw.car.tank)
tank_with_grid.name = "tank-with-grid"
tank_with_grid.equipment_grid = "large-equipment-grid"
tank_with_grid.order = "twg"
data:extend{tank_with_grid}

local superfast_transport_belt = util.table.deepcopy(data.raw["transport-belt"]["transport-belt"])
superfast_transport_belt.name = "superfast-transport-belt"
superfast_transport_belt.speed = 0.5
superfast_transport_belt.order = "sftb"
data:extend{superfast_transport_belt}

local productive_assembler = util.table.deepcopy(data.raw["assembling-machine"]["assembling-machine-1"])
productive_assembler.name = "productive-assembler"
productive_assembler.order = "productive-assembler"
productive_assembler.base_productivity = 1
productive_assembler.module_specification =
{
  module_slots = 5
}
productive_assembler.allowed_effects = {"consumption", "speed", "productivity", "pollution"}
data.raw["assembling-machine"][productive_assembler.name] = productive_assembler

local productive_lab = util.table.deepcopy(data.raw["lab"]["lab"])
productive_lab.name = "productive-lab"
productive_lab.order = "productive-lab"
productive_lab.base_productivity = 1
data.raw["lab"][productive_lab.name] = productive_lab

local productive_miner = util.table.deepcopy(data.raw["mining-drill"]["electric-mining-drill"])
productive_miner.name = "productive-miner"
productive_miner.order = "productive-miner"
productive_miner.base_productivity = 1
--productive_miner.allowed_effects = {"consumption", "speed", "productivity", "pollution"}
data.raw["mining-drill"][productive_miner.name] = productive_miner

local ultimate_transport_belt = util.table.deepcopy(data.raw["transport-belt"]["express-transport-belt"])
ultimate_transport_belt.name = "ultimate-transport-belt"
ultimate_transport_belt.order = "ultimate-transport-belt"
ultimate_transport_belt.speed = ultimate_transport_belt.speed * 4
data.raw["transport-belt"][ultimate_transport_belt.name] = ultimate_transport_belt

local ultimate_splitter = util.table.deepcopy(data.raw["splitter"]["express-splitter"])
ultimate_splitter.name = "ultimate-splitter"
ultimate_splitter.order = "ultimate-splitter"
ultimate_splitter.speed = ultimate_splitter.speed * 4
data.raw["splitter"][ultimate_splitter.name] = ultimate_splitter

-- radar with fluid energy source, efficiency scaling only
local fluid_radar = util.table.deepcopy(data.raw.radar.radar)
fluid_radar.name = "fluid-radar"
fluid_radar.order = "fluid-radar"
fluid_radar.energy_source =
{
  type = "fluid",
  fluid_box =
  {
    production_type = "input",
    pipe_picture = assembler2pipepictures(),
    pipe_covers = pipecoverspictures(),
    base_area = 5,
    pipe_connections = {{ type="input", position = {0, -2}}},
    secondary_draw_orders = {north = -1},
    filter = "steam"
  },
  burns_fluid = false,
  scale_fluid_usage = false
}
data:extend{fluid_radar}

-- same as above, with different max temp
local fluid_radar_max_temp = util.table.deepcopy(data.raw.radar["fluid-radar"])
fluid_radar_max_temp.name = "fluid-radar-max-temp"
fluid_radar_max_temp.order = "fluid-radar-max-temp"
fluid_radar_max_temp.energy_source.maximum_temperature = 600
data:extend{fluid_radar_max_temp}

-- radar with fluid energy source, fluid usage scaling
local fluid_radar_usage_scaling = util.table.deepcopy(data.raw.radar["fluid-radar"])
fluid_radar_usage_scaling.name = "fluid-radar-usage-scaling"
fluid_radar_usage_scaling.order = "fluid-radar-usage-scaling"
fluid_radar_usage_scaling.energy_source.fluid_box.filter = nil
fluid_radar_usage_scaling.energy_source.scale_fluid_usage = true
data:extend{fluid_radar_usage_scaling}

-- radar with fluid energy source, burns fluid, no scaling
local fluid_radar_burns_fluid = util.table.deepcopy(data.raw.radar["fluid-radar"])
fluid_radar_burns_fluid.name = "fluid-radar-burns"
fluid_radar_burns_fluid.order = "fluid-radar-burns"
fluid_radar_burns_fluid.energy_source.fluid_box.filter = nil
fluid_radar_burns_fluid.energy_source.burns_fluid = true
fluid_radar_burns_fluid.energy_source.scale_fluid_usage = false
fluid_radar_burns_fluid.energy_source.fluid_usage_per_tick = 10 -- must be set
data:extend{fluid_radar_burns_fluid}

-- radar with fluid energy source, burns fluid, with scaling
local fluid_radar_burns_fluid_scaling = util.table.deepcopy(data.raw.radar["fluid-radar-burns"])
fluid_radar_burns_fluid_scaling.name = "fluid-radar-burns-scaling"
fluid_radar_burns_fluid_scaling.order = "fluid-radar-burns-scaling"
fluid_radar_burns_fluid_scaling.energy_source.scale_fluid_usage = true
data:extend{fluid_radar_burns_fluid_scaling}

-- non-square assembling machine
local rectangular_assembling_machine = util.table.deepcopy(data.raw["assembling-machine"]["assembling-machine-3"])
rectangular_assembling_machine.name = "rectangular-assembling-machine"
rectangular_assembling_machine.order = "rectangular-assembling-machine"
rectangular_assembling_machine.minable = {mining_time = 1, result = "rectangular-assembling-machine"}
rectangular_assembling_machine.collision_box = {{-1.2, -0.7}, {1.2, 0.7}}
rectangular_assembling_machine.selection_box = {{-1.5, -1}, {1.5, 1}}
rectangular_assembling_machine.fluid_boxes = nil
data:extend{rectangular_assembling_machine}

-- generator with fluid energy source, fluid usage scaling
local generator_fluid_usage_scaling = util.table.deepcopy(data.raw.generator["steam-engine"])
generator_fluid_usage_scaling.name = "generator-fluid-usage-scaling"
generator_fluid_usage_scaling.order = "generator-fluid-usage-scaling"
generator_fluid_usage_scaling.scale_fluid_usage = true
data:extend{generator_fluid_usage_scaling}

local generator_fluid_burning = util.table.deepcopy(data.raw.generator["steam-engine"])
generator_fluid_burning.name = "generator-fluid-burning"
generator_fluid_burning.order = "generator-fluid-burning"
generator_fluid_burning.burns_fluid = true
generator_fluid_burning.fluid_box.filter = nil
generator_fluid_burning.max_power_output = "900kW"
generator_fluid_burning.fluid_usage_per_tick = 7.5
data:extend{generator_fluid_burning}

-- long pipe to ground
long_pipe_to_ground = util.table.deepcopy(data.raw["pipe-to-ground"]["pipe-to-ground"])
long_pipe_to_ground.name = "long-pipe-to-ground"
long_pipe_to_ground.order = "abc"
long_pipe_to_ground.fluid_box =
{
  base_area = 1,
  pipe_covers = pipecoverspictures(),
  pipe_connections =
  {
    { position = {0, -1} },
    {
      position = {0, 1},
      max_underground_distance = 20
    }
  }
}
data:extend{long_pipe_to_ground}

local underground_connection_furnace = util.table.deepcopy(data.raw.furnace["electric-furnace-2"])
underground_connection_furnace.name = "electric-furnace-2-underground"
underground_connection_furnace.order = "electric-furnace-2-underground"
underground_connection_furnace.fluid_boxes =
{
  {
    production_type = "input",
    pipe_picture = assembler2pipepictures(),
    pipe_covers = pipecoverspictures(),
    base_area = 10,
    base_level = -1,
    pipe_connections = {{ type="input", position = {0, -2}, max_underground_distance = 10 }}
  },
  {
    production_type = "output",
    pipe_picture = assembler2pipepictures(),
    pipe_covers = pipecoverspictures(),
    base_area = 10,
    base_level = 1,
    pipe_connections = {{ type="output", position = {0, 2}, max_underground_distance = 10 }}
  }
}
data:extend{underground_connection_furnace}

local burner_inserter = util.copy(data.raw.inserter["burner-inserter"])
burner_inserter.name = "leech-burner-inserter"
burner_inserter.order = "hii"
burner_inserter.allow_burner_leech = true
data:extend{burner_inserter}

local fluid_inserter = util.table.deepcopy(data.raw.inserter.inserter)
fluid_inserter.name = "fluid-inserter"
fluid_inserter.order = "fluid-inserter"
fluid_inserter.energy_source =
{
  type = "fluid",
  scale_fluid_usage = true,
  fluid_usage_per_tick = 1,
  fluid_box = {
    production_type = "input",
    pipe_covers = pipecoverspictures(),
    base_area = 10,
    base_level = -1,
    pipe_connections = {
      { type="input", position = {1, 0} }
    }
  },
}
data:extend{fluid_inserter}

local underground_boiler = util.table.deepcopy(data.raw.boiler.boiler)
underground_boiler.name = "underground-boiler"
underground_boiler.order = "underground-boiler"
underground_boiler.fluid_box =
{
  base_area = 1,
  height = 2,
  base_level = -1,
  pipe_covers = pipecoverspictures(),
  pipe_connections =
  {
    {type = "input-output", position = {-2, 0.5}, max_underground_distance = 10},
    {type = "input-output", position = {2, 0.5}, max_underground_distance = 10}
  },
  production_type = "input-output",
  filter = "water"
}
underground_boiler.output_fluid_box =
{
  base_area = 1,
  height = 2,
  base_level = 1,
  pipe_covers = pipecoverspictures(),
  pipe_connections =
  {
    {type = "output", position = {0, -1.5}, max_underground_distance = 10}
  },
  production_type = "output",
  filter = "steam"
}
data:extend{underground_boiler}

local passThroughBoiler = util.table.deepcopy(data.raw.boiler.boiler)
passThroughBoiler.name = "pass-through-underground-boiler"
passThroughBoiler.order = "pass-through-underground-boiler"
passThroughBoiler.collision_box = {{-0.4, -0.4}, {0.4, 0.4}}
passThroughBoiler.selection_box = {{-0.45, -0.45}, {0.45, 0.45}}
passThroughBoiler.fluid_box =
{
  base_area = 1,
  height = 2,
  base_level = -1,
  pipe_covers = pipecoverspictures(),
  pipe_connections =
  {
    {type = "input-output", position = {-1, 0}, max_underground_distance = 10},
    {type = "input-output", position = {1, 0}, max_underground_distance = 10}
  },
  production_type = "input-output",
  filter = "water"
}
passThroughBoiler.output_fluid_box =
{
  base_area = 1,
  height = 2,
  base_level = 1,
  pipe_covers = pipecoverspictures(),
  pipe_connections =
  {
    {type = "output", position = {0, -1}, max_underground_distance = 10},
    {type = "output", position = {0, 1}, max_underground_distance = 10}
  },
  production_type = "output",
  filter = "steam"
}
data:extend{passThroughBoiler}

-- Test entities from 74746
function furnace74746(name, energySourceConnections, inputConnections, outputConnections)
  local furnace = util.table.deepcopy(data.raw.furnace["electric-furnace"])
  furnace.name = name
  furnace.order = name
  furnace.minable = {mining_time = 0.2, result = name}
  furnace.fast_replaceable_group = nil
  furnace.energy_source = {
    type = "fluid",
    scale_fluid_usage = true,
    fluid_usage_per_tick = 1,
    fluid_box = {
      production_type = "input",
      pipe_covers = pipecoverspictures(),
      base_area = 10,
      base_level = -1,
      pipe_connections = energySourceConnections
    },
    emissions_per_minute = 1
  }
  furnace.fluid_boxes = {
    {
      production_type = "input",
      pipe_covers = pipecoverspictures(),
      base_area = 10,
      base_level = -1,
      pipe_connections = inputConnections
    },
    {
      production_type = "output",
      pipe_covers = pipecoverspictures(),
      base_level = 1,
      pipe_connections = outputConnections
    }
  }
  data:extend{furnace}

  -- item needed for spawning ghosts
  local furnaceItem = util.table.deepcopy(data.raw.item["electric-furnace"])
  furnaceItem.name = name
  furnaceItem.place_result = name
  data:extend{furnaceItem}
end

-- lower left underground
local LL = {
  { type="input-output", position = {-2, 1}, max_underground_distance = 10 }
}
-- lower right underground
local LR = {
  { type="input-output", position = {2, 1}, max_underground_distance = 10 }
}
-- upper group
local UG = {
  { type="input-output", position = {-1, -2} },
  { type="input-output", position = {2, -1}, max_underground_distance = 10 }
}
-- reverse order upper group
local rUG = {
  { type="input-output", position = {2, -1}, max_underground_distance = 10 },
  { type="input-output", position = {-1, -2} }
}

furnace74746("furnace-74746-a",  LL,  LR,  UG)
furnace74746("furnace-74746-b",  LL,  LR, rUG)
furnace74746("furnace-74746-c",  LL,  UG,  LR)
furnace74746("furnace-74746-d",  LL, rUG,  LR)
furnace74746("furnace-74746-e",  LR,  LL,  UG)
furnace74746("furnace-74746-f",  LR,  LL, rUG)
furnace74746("furnace-74746-g",  LR,  UG,  LL)
furnace74746("furnace-74746-h",  LR, rUG,  LL)
furnace74746("furnace-74746-i",  UG,  LR,  LL)
furnace74746("furnace-74746-j", rUG,  LR,  LL)
furnace74746("furnace-74746-k",  UG,  LL,  LR)
furnace74746("furnace-74746-l", rUG,  LL,  LR)

local UG = {
  { type="input-output", position = {-2, -1}, max_underground_distance = 10 },
  { type="input-output", position = {2, -1}, max_underground_distance = 10 }
}
local LL = {
  { type="input-output", position = {-2, 1}, max_underground_distance = 10 },
  { type="input-output", position = {-1, 2} }
}
local LR = {
  { type="input-output", position = {2, 1}, max_underground_distance = 10 },
  { type="input-output", position = {1, 2} }
}

furnace74746("furnace-74746-1", LL, LR, UG)
furnace74746("furnace-74746-2", LL, UG, LR)
furnace74746("furnace-74746-3", LR, UG, LL)
furnace74746("furnace-74746-4", LR, LL, UG)
furnace74746("furnace-74746-5", UG, LL, LR)
furnace74746("furnace-74746-6", UG, LR, LL)

function addFluidEnergySource(entityType, originalName, newName, connections)
  local entity = util.table.deepcopy(data.raw[entityType][originalName])
  entity.name = newName
  entity.order = newName
  entity.energy_source = {
    type = "fluid",
    scale_fluid_usage = true,
    fluid_usage_per_tick = 1,
    fluid_box = {
      production_type = "input",
      pipe_covers = pipecoverspictures(),
      base_area = 10,
      base_level = -1,
      pipe_connections = connections
    },
    emissions_per_minute = 1
  }
  data:extend{entity}
end
function createConnections(width, height)
  return {
    { type="input-output", position = {-0.5 - width/2, ((height+1)/2)%1}, max_underground_distance = 10 },
    { type="input-output", position = {0.5 + width/2, ((height+1)/2)%1}, max_underground_distance = 10 },
    { type="input-output", position = {((width+1)/2)%1, -0.5 - height/2} },
    { type="input-output", position = {((width+1)/2)%1, 0.5 + height/2} }
  }
end
function createConnectionsAtCorners(width, height)
  return {
    { type="input-output", position = {-0.5 - width/2, 0.5 - height/2}, max_underground_distance = 10 },
    { type="input-output", position = {0.5 + width/2, 0.5 - height/2}, max_underground_distance = 10 },
    { type="input-output", position = {0.5 - width/2, -0.5 - height/2} },
    { type="input-output", position = {0.5 - width/2, 0.5 + height/2} }
  }
end
addFluidEnergySource("inserter", "inserter", "fluidpowered-inserter", createConnections(1,1))
addFluidEnergySource("mining-drill", "electric-mining-drill", "fluidpowered-mining-drill", createConnectionsAtCorners(3,3))
addFluidEnergySource("boiler", "boiler", "fluidpowered-boiler", {
  { type="input-output", position = {1, 1.5}, max_underground_distance = 10 },
  { type="input-output", position = {-1, 1.5}, max_underground_distance = 10 },
  { type="input-output", position = {1, -1.5} },
  { type="input-output", position = {-1, -1.5} }
})
addFluidEnergySource("lab", "lab", "fluidpowered-lab", createConnections(3,3))
addFluidEnergySource("radar", "radar", "fluidpowered-radar", createConnections(3,3))
addFluidEnergySource("rocket-silo", "rocket-silo", "fluidpowered-rocket-silo", createConnections(9,9))
addFluidEnergySource("reactor", "nuclear-reactor", "fluidpowered-nuclear-reactor", createConnections(5,5))
addFluidEnergySource("assembling-machine", "assembling-machine-1", "fluidpowered-assembling-machine-1", createConnectionsAtCorners(3,3))

local test_tank = util.table.deepcopy(data.raw["car"]["tank"])
test_tank.name = "test-tank"
test_tank.equipment_grid = "large-equipment-grid"
test_tank.order = "bleh"
data:extend({test_tank})

data.raw["burner-generator"]["burner-generator"].max_power_output = "30MW"

local multi_category_ammo_turret = util.table.deepcopy(data.raw["ammo-turret"]["gun-turret"])
multi_category_ammo_turret.name = "multi-category-ammo-turret"
multi_category_ammo_turret.order = "multi-category-ammo-turret"
multi_category_ammo_turret.attack_parameters.ammo_category = nil
multi_category_ammo_turret.attack_parameters.ammo_categories = { "bullet", "rocket" }
data:extend{multi_category_ammo_turret}

local multi_category_artillery_cannon = util.table.deepcopy(data.raw.gun["artillery-wagon-cannon"])
multi_category_artillery_cannon.name = "multi-category-artillery-cannon"
multi_category_artillery_cannon.attack_parameters.ammo_category = nil
multi_category_artillery_cannon.attack_parameters.ammo_categories = { "artillery-shell", "cannon-shell" }
local multi_category_artillery_turret = util.table.deepcopy(data.raw["artillery-turret"]["artillery-turret"])
multi_category_artillery_turret.name = "multi-category-artillery-turret"
multi_category_artillery_turret.order = "multi-category-artillery-turret"
multi_category_artillery_turret.gun = "multi-category-artillery-cannon"
data:extend{multi_category_artillery_cannon, multi_category_artillery_turret}

local biterWithPlayerLayer = util.table.deepcopy(data.raw["unit"]["small-biter"])
biterWithPlayerLayer.name = "biter-with-player-layer"
biterWithPlayerLayer.collision_box = {{-0.1, -0.1}, {0.1, 0.1}}
biterWithPlayerLayer.collision_mask = {"not-colliding-with-itself", "player-layer", "train-layer", "consider-tile-transitions"}
biterWithPlayerLayer.ai_settings.path_resolution_modifier = 1
data:extend{biterWithPlayerLayer}

local insane_locomotive = util.table.deepcopy(data.raw["locomotive"]["locomotive"])
insane_locomotive.name = "insane-locomotive"
insane_locomotive.order = "insane-locomotive"
insane_locomotive.weight = 100
insane_locomotive.max_speed = 30
insane_locomotive.max_power = "5000kW"
insane_locomotive.reversing_power_modifier = 0.6
insane_locomotive.braking_force = 10000
insane_locomotive.friction_force = 0.0015
insane_locomotive.vertical_selection_shift = -0.5
insane_locomotive.air_resistance = 0.002
-- insane_locomotive.connection_distance = 3.3
-- insane_locomotive.joint_distance = 4.6
insane_locomotive.energy_per_hit_point = 5
insane_locomotive.burner =
{
  effectivity = 1000,
  fuel_inventory_size = 3,
  fuel_category = "chemical"
}
data.raw["locomotive"][insane_locomotive.name] = insane_locomotive

local smallBiterAffectedByTiles = util.table.deepcopy(data.raw.unit["small-biter"])
smallBiterAffectedByTiles.name = "small-biter-affected-by-tiles"
smallBiterAffectedByTiles.affected_by_tiles = true
data.raw.unit[smallBiterAffectedByTiles.name] = smallBiterAffectedByTiles

local railSignalNoCollisionBox = util.table.deepcopy(data.raw["rail-signal"]["rail-signal"])
railSignalNoCollisionBox.name = "rail-signal-no-collision-box"
railSignalNoCollisionBox.order = "rail-signal-no-collision-box"
railSignalNoCollisionBox.collision_box = nil
data.raw["rail-signal"][railSignalNoCollisionBox.name] = railSignalNoCollisionBox

local fluidWagonWithGrid = util.table.deepcopy(data.raw["fluid-wagon"]["fluid-wagon"])
fluidWagonWithGrid.name = "fluid-wagon-with-grid"
fluidWagonWithGrid.order = "fluid-wagon-with-grid"
fluidWagonWithGrid.equipment_grid = "large-equipment-grid"
data.raw["fluid-wagon"][fluidWagonWithGrid.name] = fluidWagonWithGrid

local flying_biter = util.table.deepcopy(data.raw.unit["small-biter"])
flying_biter.name = "flying-biter"
flying_biter.collision_mask = {}
data.raw.unit[flying_biter.name] = flying_biter

local dummyResource = util.table.deepcopy(data.raw.resource["coal"])
dummyResource.name = "unobtanium"
dummyResource.autoplace = nil
dummyResource.collision_box = {{-0.75, -0.75}, {0.75, 0.75}}
dummyResource.tile_width = 2
dummyResource.tile_height = 2
data.raw.resource[dummyResource.name] = dummyResource

local furnace_without_module_slots = util.table.deepcopy(data.raw.furnace["electric-furnace"])
furnace_without_module_slots.name = "electric-furnace-without-module-slots"
furnace_without_module_slots.order = "a"
furnace_without_module_slots.module_specification.module_slots = 0
data.raw.furnace[furnace_without_module_slots.name] = furnace_without_module_slots

local assembling_machine_without_module_slots = util.table.deepcopy(data.raw["assembling-machine"]["assembling-machine-3"])
assembling_machine_without_module_slots.name = "assembling-machine-without-module-slots"
assembling_machine_without_module_slots.order = "a"
assembling_machine_without_module_slots.module_specification.module_slots = 0
data.raw["assembling-machine"][assembling_machine_without_module_slots.name] = assembling_machine_without_module_slots

local mining_drill_without_module_slots = util.table.deepcopy(data.raw["mining-drill"]["electric-mining-drill"])
mining_drill_without_module_slots.name = "mining-drill-without-module-slots"
mining_drill_without_module_slots.order = "a"
mining_drill_without_module_slots.module_specification.module_slots = 0
data.raw["mining-drill"][mining_drill_without_module_slots.name] = mining_drill_without_module_slots

local lab_without_module_slots = util.table.deepcopy(data.raw.lab["lab"])
lab_without_module_slots.name = "lab-without-module-slots"
lab_without_module_slots.order = "a"
lab_without_module_slots.module_specification.module_slots = 0
data.raw.lab[lab_without_module_slots.name] = lab_without_module_slots

local partial_lab_a = util.table.deepcopy(data.raw.lab["lab"])
partial_lab_a.name = "partial-lab-a"
partial_lab_a.order = "a"
partial_lab_a.inputs = { "chemical-science-pack", "production-science-pack" }
partial_lab_a.fast_replaceable_group = "partial-labs"
partial_lab_a.minable.result = "partial-lab-a"
data.raw.lab[partial_lab_a.name] = partial_lab_a

local partial_lab_b = util.table.deepcopy(data.raw.lab["lab"])
partial_lab_b.name = "partial-lab-b"
partial_lab_b.order = "a"
partial_lab_b.inputs = { "production-science-pack", "utility-science-pack" }
partial_lab_b.fast_replaceable_group = "partial-labs"
partial_lab_b.minable.result = "partial-lab-b"
data.raw.lab[partial_lab_b.name] = partial_lab_b

local fluidWagon1Tank = util.table.deepcopy(data.raw["fluid-wagon"]["fluid-wagon"])
fluidWagon1Tank.name = "fluid-wagon-1-tank"
fluidWagon1Tank.order = "fluid-wagon-1-tank"
fluidWagon1Tank.tank_count = 1
data.raw["fluid-wagon"][fluidWagon1Tank.name] = fluidWagon1Tank

local fluidWagon2Tank = util.table.deepcopy(data.raw["fluid-wagon"]["fluid-wagon"])
fluidWagon2Tank.name = "fluid-wagon-2-tanks"
fluidWagon2Tank.order = "fluid-wagon-2-tanks"
fluidWagon2Tank.tank_count = 2
data.raw["fluid-wagon"][fluidWagon2Tank.name] = fluidWagon2Tank

local inOutChemicalPlant = util.table.deepcopy(data.raw["assembling-machine"]["chemical-plant"])
inOutChemicalPlant.name = "in-out-chemical-plant"
inOutChemicalPlant.order = "a-a"
for _,fluidBox in pairs(inOutChemicalPlant.fluid_boxes) do
  for _,connection in pairs(fluidBox.pipe_connections) do
    connection.type = "input-output"
  end
end
data.raw["assembling-machine"][inOutChemicalPlant.name] = inOutChemicalPlant

-- just a copy so electric-mining-drill can be fast-replaced
local anotherMiningDrill = util.table.deepcopy(data.raw["mining-drill"]["electric-mining-drill"])
anotherMiningDrill.name = "another-mining-drill"
anotherMiningDrill.order = "another-mining-drill"
anotherMiningDrill.minable.result = "another-mining-drill"
data.raw["mining-drill"][anotherMiningDrill.name] = anotherMiningDrill
